% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_stat.R
\name{..cor_stat}
\alias{..cor_stat}
\title{Calculate correlation for the general stationary model}
\usage{
..cor_stat(cor_base, lagrangian, lambda, v1, v2, k = 2, h1, h2, u)
}
\arguments{
\item{cor_base}{An array of base cross-correlation matrices.}

\item{lagrangian}{Lagrangian model, \code{none}, \code{lagr_tri}, or \code{lagr_askey}.}

\item{lambda}{Weight of the Lagrangian term, \eqn{\lambda\in[0, 1]}.}

\item{v1}{Prevailing wind, u-component.}

\item{v2}{Prevailing wind, v-component.}

\item{k}{Scale parameter of \eqn{\|\boldsymbol v\|}, \eqn{k>0}. Default is 2.}

\item{h1}{Horizontal distance matrix or array.}

\item{h2}{Vertical distance matrix or array, same dimension as \code{h1}.}

\item{u}{Time lag, same dimension as \code{h1}.}
}
\value{
Correlations for the general stationary model.
}
\description{
Calculate correlation for the general stationary model
}
\details{
This function is a special case of \code{\link[=.cor_stat]{.cor_stat()}}. It is used inside
\code{\link[=fit_lagr]{fit_lagr()}}.
}
\keyword{internal}
