% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_module_loop_plu_comma.R
\name{process_module_loop_plu_comma}
\alias{process_module_loop_plu_comma}
\title{Process Module Components with Plus and Comma Handling}
\usage{
process_module_loop_plu_comma(
  KO_vector,
  module_abundance,
  process_step_plus,
  process_step_comma,
  process_step_direct,
  aggregrate_rowname = "step_1",
  step_count = 1,
  plus_scale_method,
  comma_scale_method
)
}
\arguments{
\item{KO_vector}{Character vector of KO identifiers to process}

\item{module_abundance}{Data frame containing KO abundance data}

\item{process_step_plus}{Function to handle plus-separated KOs (required components)}

\item{process_step_comma}{Function to handle comma-separated KOs (alternative forms)}

\item{process_step_direct}{Function to handle individual KOs}

\item{aggregrate_rowname}{Base name for row aggregation (default: 'step_1')}

\item{step_count}{Counter for processing steps (default: 1)}

\item{plus_scale_method}{Scaling method for plus-separated KOs ("mean", "min", or "max")}

\item{comma_scale_method}{Scaling method for comma-separated KOs ("sum" or "max")}
}
\value{
List containing:
- abundance_table: Processed abundance values
- step_count: Updated step counter
- abundance_log: log
}
\description{
Processes a vector of KOs, applying different handling methods depending on whether
they contain plus signs, commas, or both. Handles complex pathway definitions with
both required components (plus-separated) and alternative forms (comma-separated).
}
