% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-mcmc.R
\name{as.mcmc.mcmc}
\alias{as.mcmc.mcmc}
\title{Markov Chain Monte Carlo Objects}
\usage{
\method{as.mcmc}{mcmc}(x, ...)
}
\arguments{
\item{x}{An object that may be coerced to an mcmc object}

\item{...}{Further arguments to be passed to specific methods}
}
\description{
The function \code{mcmc} is used to create a Markov Chain Monte Carlo
   object.  The input data are taken to be a vector, or a matrix with
   one column per variable.

   If the optional arguments \code{start}, \code{end}, and \code{thin}
   are omitted then the chain is assumed to start with iteration 1 and
   have thinning interval 1. If \code{data} represents a chain that
   starts at a later iteration, the first iteration in the chain should
   be given as the \code{start} argument. Likewise, if \code{data}
   represents a chain that has already been thinned, the thinning
   interval should be given as the \code{thin} argument.

   An mcmc object may be summarized by the \code{summary} function
   and visualized with the \code{plot} function.

   MCMC objects resemble time series (\code{ts}) objects and have
   methods for the generic functions \code{time}, \code{start},
   \code{end}, \code{frequency} and \code{window}.
}
\seealso{
\code{\link[coda]{mcmc.list}},
   \code{\link[coda]{mcmcUpgrade}},
   \code{\link[coda]{thin}},
   \code{\link[coda]{window.mcmc}},
   \code{\link[coda]{summary.mcmc}},
   \code{\link[coda]{plot.mcmc}}.
}
\author{
Martyn Plummer
}
