% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbc.R
\name{SBC_test}
\alias{SBC_test}
\title{Simulation based calibration}
\usage{
SBC_test(
  ...,
  pars,
  n.draws = 25L,
  n.sim = 20L * n.draws,
  burnin = 25L,
  thin = 2L,
  show.progress = TRUE
)
}
\arguments{
\item{...}{passed to \code{\link{create_sampler}} (can be all parameters except \code{prior.only})}

\item{pars}{named list with univariate functions of the parameters to use in test. This list
is passed to argument \code{pred} of \code{\link{MCMCsim}}.}

\item{n.draws}{number of posterior draws to retain in posterior simulations.}

\item{n.sim}{number of simulation iterations.}

\item{burnin}{burnin to use in posterior simulations, passed to \code{\link{MCMCsim}}.}

\item{thin}{thinning to use in posterior simulations, passed to \code{\link{MCMCsim}}.}
}
\value{
A matrix with ranks.
}
\description{
Simulation based calibration
}
\examples{
\dontrun{
# this example takes a long time
n <- 10L  # data size
dat <- data.frame(x=runif(n))
SBC_test(~ reg(~ 1 + x, b0=c(0.25, 1), Q0=1, name="beta"),
  sigma.mod=pr_invchisq(df=1, scale=list(df=1, scale=1)), data=dat,
  pars=list(mu="beta[1]", beta_x="beta[2]", sigma="sigma_"),
  n.draws=25L, n.sim=100L*25L, thin=3L, burnin=50L
)
}

}
\references{
S. Talts, M. Betancourt, D. Simpson, A. Vehtari and A. Gelman (2018).
    Validating Bayesian inference algorithms with simulation-based calibration.
    arXiv:1804.06788.
}
\keyword{internal}
