% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{createSimilarityMat}
\alias{createSimilarityMat}
\title{Create Similarity Matrix}
\usage{
createSimilarityMat(allocations)
}
\arguments{
\item{allocations}{Matrix of sampled partitions. Columns correspond to 
items/samples being clustered, each row is a sampled partition.}
}
\value{
A symmetric N x N matrix (for N rows in allocations) describing 
the fraction of iterations for which each pairwise combination of points are
assigned the same label.
}
\description{
Constructs a similarity matrix of the pairwise coclustering 
rate.
}
\examples{

N <- 100
X <- matrix(c(rnorm(N, 0, 1), rnorm(N, 3, 1)), ncol = 2, byrow = TRUE)
Y <- matrix(c(rnorm(N, 0, 1), rnorm(N, 3, 1)), ncol = 2, byrow = TRUE)

truth <- c(rep(1, N / 2), rep(2, N / 2))
data_modelled <- list(X, Y)

V <- length(data_modelled)

# This R is much too low for real applications
R <- 100
thin <- 5
burn <- 10

K_max <- 10
K <- rep(K_max, V)
types <- rep("G", V)

mcmc_out <- callMDI(data_modelled, R, thin, types, K = K)
createSimilarityMat(mcmc_out$allocations[, , 1])
}
