% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sttc.R
\name{compute_sttc_by_well}
\alias{compute_sttc_by_well}
\title{Compute the STTC across all pairwise electrodes in well}
\usage{
compute_sttc_by_well(s, dt = 0.05, beg = NULL, end = NULL)
}
\arguments{
\item{s}{structure storing the well information}

\item{dt}{Time window for STTC (default = 0.05 seconds)}

\item{beg}{Start time in seconds (defaults to start of recording)}

\item{end}{End time in seconds (defaults to end of recording)}
}
\value{
A data frame giving all pairwise STTCs (and distance separating electrodes) on each well.
}
\description{
Compute the STTC across all pairwise electrodes in well
}
\details{
For each pair of electrodes (excluding autocorrelations), we calculate the STTC. 
If a well has one (or no) electrodes, no STTCs are calculated for that well.
}
\author{
Stephen Eglen
}
