% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regeneration.R
\name{regeneration}
\alias{regeneration}
\alias{recruitment}
\alias{resprouting}
\title{Plant regeneration}
\usage{
recruitment(
  forest,
  SpParams,
  control,
  minMonthTemp,
  moistureIndex,
  verbose = FALSE
)

resprouting(
  forest,
  internalMortality,
  SpParams,
  control,
  management_results = NULL
)
}
\arguments{
\item{forest}{An object of class \code{\link{forest}}.}

\item{SpParams}{A data frame with species parameters (see \code{\link{SpParamsMED}} and \code{\link{SpParamsDefinition}}).}

\item{control}{A list with default control parameters (see \code{\link{defaultControl}}).}

\item{minMonthTemp}{Minimum month temperature.}

\item{moistureIndex}{Moisture index (annual precipitation over annual potential evapotranspiration).}

\item{verbose}{Boolean flag to indicate console output during calculations.}

\item{internalMortality}{A data frame with mortality occurred in the last year of simulation.}

\item{management_results}{The result of calling a management function (see \code{\link{defaultManagementFunction}}).}
}
\value{
An object of class \code{\link{forest}} with the new plant cohorts.
}
\description{
Annual plant regeneration from seed recruitment or from resprouting
}
\details{
\itemize{
  \item{Species can recruit if adults (sufficiently tall individuals) are present (seed rain can also be specified in a control parameter). 
Minimum month temperature and moisture index values are used to determine if recruitment was successful. 
Species also require a minimum amount of light at the ground level.}
  \item{Resprouting occurs after “mortality” from die-back (including drought- or pathogen-induced dessication), 
cutting or burning of the aerial part in a species with resprouting ability, 
but not after carbon starvation or baseline mortality (unspecific mortality causes).}
}
}
\examples{
#Load example plot plant data
data(exampleforestMED)

#Default species parameterization
data(SpParamsMED)

#Initialize control parameters
control <- defaultControl("Granier")
control$recruitmentMode = "deterministic" 

#Recruitment limits
plant_parameter(exampleforestMED, SpParamsMED, "MinTempRecr")
plant_parameter(exampleforestMED, SpParamsMED, "MinMoistureRecr")

#Compare seed recruitment outcomes
recruitment(exampleforestMED, SpParamsMED, control, 0, 0.25)
recruitment(exampleforestMED, SpParamsMED, control, 3, 0.25)

}
\seealso{
\code{\link{fordyn}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
