% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sureau_ecos}
\alias{sureau_ecos}
\alias{initSureauNetworks}
\alias{semi_implicit_integration}
\title{Sureau-ECOS inner functions for testing only}
\usage{
initSureauNetworks(x)

semi_implicit_integration(
  network,
  dt,
  opt,
  stemCavitationRecovery = "annual",
  leafCavitationRecovery = "total"
)
}
\arguments{
\item{x}{An object of class \code{\link{spwbInput}} or \code{\link{growthInput}} created using \code{transpirationMode = "Sureau"}.}

\item{network}{A hydraulic network element of the list returned by \code{initSureauNetworks}}

\item{dt}{Smallest time step (seconds)}

\item{opt}{Option flag vector}

\item{stemCavitationRecovery, leafCavitationRecovery}{A string indicating how refilling of embolized conduits is done:
\itemize{
  \item{"none" - no refilling.}
  \item{"annual" - every first day of the year.}
  \item{"rate" - following a rate of new sapwood formation.}
  \item{"total" - instantaneous complete refilling.}
}}
}
\value{
Function \code{initSureauNetworks} returns a vector of length equal to the number of cohorts. Each element is a list with Sureau-ECOS parameters.
Function \code{semi_implicit_integration} does not return anything, but modifies input parameter \code{network}.
}
\description{
Function \code{initSureauNetworks} initializes hydraulic networks for all plant cohorts in x
Function \code{semi_implicit_integration} updates water potentials and cavitation across the hydraulic network
}
\references{
Ruffault J, Pimont F, Cochard H, Dupuy JL, Martin-StPaul N (2022) 
SurEau-Ecos v2.0: a trait-based plant hydraulics model for simulations of plant water status and drought-induced mortality at the ecosystem level.
Geoscientific Model Development 15, 5593-5626 (doi:10.5194/gmd-15-5593-2022).
}
\seealso{
\code{\link{spwb}}
}
\author{
\itemize{
  \item{Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF}
  \item{Nicolas Martin-StPaul, URFM-INRAE}
}
}
\keyword{internal}
