% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_forests.R
\name{forest_parametrization}
\alias{forest_parametrization}
\alias{impute_forests}
\alias{modify_forest_structure}
\alias{check_forests}
\title{Landscape forest parametrization}
\usage{
impute_forests(
  x,
  sf_fi,
  dem,
  forest_map,
  var_class = NA,
  max_distance_km = 100,
  replace_existing = FALSE,
  missing_class_imputation = FALSE,
  missing_class_forest = NULL,
  merge_trees = TRUE,
  merge_shrubs = TRUE,
  progress = TRUE
)

modify_forest_structure(
  x,
  structure_map,
  variable,
  map_var = NA,
  ratio_limits = NULL,
  minDBH = 7.5,
  progress = TRUE
)

check_forests(x, progress = FALSE)
}
\arguments{
\item{x}{An object of class \code{\link{sf}}. If it contains a column named 'land_cover_type', imputation
will be performed for locations whose land cover is "wildland". Otherwise, forest imputation is done for all locations.
For structural corrections or when checking, \code{x} should already contain a column named 'forest' containing  \code{\link{forest}} objects.}

\item{sf_fi}{An object of class \code{\link{sf}} with forest inventory data column 'forest'.}

\item{dem}{A digital elevation model (class \code{\link{rast}}) with meters as units}

\item{forest_map}{An object of class \code{\link{rast}} or \code{\link{vect}} with the forest class map}

\item{var_class}{Variable name or index containing forest classes in \code{forest_map}. If missing the first column is taken.}

\item{max_distance_km}{Maximum distance, in km, for forest inventory plot imputation.}

\item{replace_existing}{A logical flag to force the replacement of existing \code{\link{forest}} objects, when present.}

\item{missing_class_imputation}{A logical flag to force imputation in locations where forest class is not defined. If \code{missing_class_imputation = TRUE}, imputation in those locations will be based on geographic and topographic criteria only.}

\item{missing_class_forest}{A \code{\link{forest}} object to be used for locations with missing class.}

\item{merge_trees}{A logical flag to simplify tree cohorts by merging tree records in DBH classes (see \code{\link{forest_mergeTrees}}).}

\item{merge_shrubs}{A logical flag to simplify shrub cohorts by merging shrub records in height classes (see \code{\link{forest_mergeShrubs}}).}

\item{progress}{A logical flag to print console output.}

\item{structure_map}{An object of class \code{\link{rast}} or \code{\link{vect}} with a forest structural variable map}

\item{variable}{Structural variable to correct. See options in details.}

\item{map_var}{Variable name or index containing structural variable in 'structure_map'. If missing the first column is taken.}

\item{ratio_limits}{Limits for ratio of variable in corrections, used to avoid outliers.}

\item{minDBH}{Minimum diameter for stand metric calculation. If \code{minDBH > 0} then those stands with smaller trees will not be corrected
because of the missing stand metric.}
}
\value{
Functions \code{impute_forests()} and \code{modify_forest_structure()} return a modified object of class \code{\link{sf}}.
Function \code{check_forests()} returns an invisible data frame with columns indicating missing forest data and missing values in tree or shrub parameters.
}
\description{
Utility functions to define forest inputs in a landscape:
\itemize{
\item{\code{impute_forests()} performs imputation of forest objects from a forest inventory using a forest map to match forest types and topography as covariates. }
\item{\code{modify_forest_structure()} uses forest structure rasters supplied by the user to correct forest structure metrics.}
\item{\code{check_forests()} checks that forests are defined and do not contain missing values in key tree/shrub attributes.}
}
}
\details{
Function \code{impute_forests()} performs imputation of forest inventory plots on target locations provided that
they correspond to the same forest class, defined in the input forest map, and are geographically closer than a distance threshold (\code{max_distance_km}).
Among the multiple stands that can have fulfill these two requirements, the function chooses the one that has the most similar elevation
and position in the N-to-S slopes (i.e. the product of the cosine of aspect and slope). Both topographic
features are standardized to zero mean and unit standard deviation (using the supplied digital elevation model to calculate those metrics), to make their
weight on the imputation equal. This imputation method will be more or less successful depending on the resolution of forest classes and
the number of forest inventory plots available for each of them. Additionally, tree and shrub cohorts can be simplified after imputation (\code{merge_trees} and \code{merge_shrubs}),
to reduce the number of records (and hence, speed-up simulations).

Function \code{modify_forest_structure()} can be used to modify specific structure variables of the imputed forests
building on rasters supplied by the user (typically from aerial or satellite LiDAR products). For any given metric,
the function will calculate the ratio of the structure metric between the target \code{\link{forest}} object (see \code{\link[medfate]{stand_basalArea}})
and the input map in the target location. Locations where the metric value in the map is missing are left unmodified.
Options for structural variables are the following:
\itemize{
\item{\code{mean_tree_height}: Should contain values in cm. Corrects tree heights and diameters (assuming a constant diameter-height relationship).}
\item{\code{dominant_tree_height}: Should contain values in cm. Corrects tree heights and diameters (assuming a constant diameter-height relationship).}
\item{\code{tree_density}: Should contain values in individuals per hectare. Corrects tree density.}
\item{\code{basal_area}: Should contain values in squared meters per hectare (m2/ha). Corrects tree density.}
\item{\code{mean_shrub_height}: Should contain values in cm. Corrects shrub cover.}
}

Function \code{check_forest()} checks first that \code{\link{forest}} objects are defined in "wildland" locations. Then, it looks for missing
data in tree or shrub attributes required for simulations. The function does not modify the data.
}
\examples{
# See package vignettes 'Preparing inputs'
}
\seealso{
\code{\link[=add_topography]{add_topography()}}, \code{\link[=add_forests]{add_forests()}}, \code{\link[=add_soilgrids]{add_soilgrids()}}, \code{\link[medfate]{forest_mergeTrees}}
}
