% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/converters.r
\docType{methods}
\name{Converters}
\alias{Converters}
\alias{as.memuse}
\alias{as.memuse,numeric-method}
\alias{as.memuse,object_size-method}
\alias{as.memuse,character-method}
\alias{as.character,memuse-method}
\alias{as.numeric,memuse-method}
\title{Converters}
\usage{
as.memuse(x, ...)

\S4method{as.memuse}{numeric}(x, unit = "best", prefix = "IEC",
  names = "short")

\S4method{as.memuse}{object_size}(x, unit = "best", prefix = "IEC",
  names = "short")

\S4method{as.memuse}{character}(x, unit = "best", prefix = "IEC",
  names = "short")

\S4method{as.character}{memuse}(x, ...)

\S4method{as.numeric}{memuse}(x, ...)
}
\arguments{
\item{x}{Numeric value, object_size data, or appropriate string (see details
section for more information).}

\item{...}{Additional arguments.}

\item{unit}{\code{string}; the unit of storage, such as "MiB" or "MB",
depending on prefix.  Case is ignored.}

\item{prefix}{\code{string}; the unit prefix, namely IEC or SI.  Case
is ignored.}

\item{names}{\code{string}; control for whether the unit names should
be printed out or their abbreviation should be used.  Options are "long" and
"short", respectively.  Case is ignored.}
}
\value{
Returns a character, numeric, or \code{memuse} object, depending on the call.
}
\description{
Converter methods between memuse and base R objects.
}
\details{
These methods convert numeric, \code{object_size}, and string (character)
objects to/from \code{memuse} objects.

\code{as.numeric(x)} for a memuse object \code{x} is just sugar for
\code{mu.size(x, as.is=FALSE)}

Strings must be of the same form as the printed output of a a memuse object.
For example, "100 KiB" is valid, but "100 (KiB)" is not.  As always, case of
the unit is ignored, and so "100 kib" would be valid as well.
}
\examples{
\dontrun{
as.memuse(10)
}

}
\seealso{
\code{ \link{memuse-class} \link{Accessors} }
}
\keyword{Methods}
