% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/howbig.r
\name{howbig}
\alias{howbig}
\title{howbig}
\usage{
howbig(
  nrow = 1,
  ncol = 1,
  representation = "dense",
  unit = "best",
  prefix = "IEC",
  names = "short",
  ...,
  sparsity = 0.05,
  type = "double",
  intsize = 4
)
}
\arguments{
\item{nrow, ncol}{Number of (global) rows/columns of the matrix.}

\item{representation}{The kind of storage the object would be in, i.e. "dense" or "sparse".}

\item{unit}{string; the unit of storage, such as "MiB" or "MB", depending on
prefix.  Case is ignored.}

\item{prefix}{string; the unit prefix, namely IEC or SI.  Case is ignored.}

\item{names}{string; control for whether the unit names should be
printed out or their abbreviation should be used.  Options are "long" and
"short", respectively.  Case is ignored.}

\item{...}{Additional arguments.}

\item{sparsity}{The proportion of sparsity of the matrix if
\code{representation="sparse"}}

\item{type}{"double" or "int"; the storage type of the data matrix.  If you
don't know the type, it is probably stored as a double, so the default value
will suffice.}

\item{intsize}{The size (in bytes) of an integer.  Default is 4, but this is
platform dependent.}
}
\value{
returns a \code{memuse} class object.
}
\description{
Determines the memory usage for a dense, in-core, numeric matrix of
specified rows/columns.
}
\details{
These functions provide the memory usage of an unallocated, dense, in-core,
numeric matrix.  As the name suggests, \code{howbig()} simply returns the
size (as a \code{memuse} object).
}
\examples{
\dontrun{
# size of a 1000x1000 matrix
howbig(1000, 1000)
}

}
\seealso{
\code{\link{howmany}}
}
