% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trimfill.R
\name{trimfill.meta}
\alias{trimfill.meta}
\alias{trimfill}
\alias{trimfill.default}
\title{Trim-and-fill method to adjust for bias in meta-analysis}
\usage{
\method{trimfill}{meta}(
  x,
  left = NULL,
  ma.common = TRUE,
  type = "L",
  n.iter.max = 50,
  common = FALSE,
  random = TRUE,
  prediction = x$prediction,
  backtransf = x$backtransf,
  pscale = x$pscale,
  irscale = x$irscale,
  irunit = x$irunit,
  silent = TRUE,
  warn.deprecated = gs("warn.deprecated"),
  ...
)

\method{trimfill}{default}(
  x,
  seTE,
  left = NULL,
  ma.common = TRUE,
  type = "L",
  n.iter.max = 50,
  sm = "",
  studlab = NULL,
  level = 0.95,
  level.ma = level,
  common = FALSE,
  random = TRUE,
  method.random.ci = gs("method.random.ci"),
  adhoc.hakn.ci = gs("adhoc.hakn.ci"),
  method.tau = gs("method.tau"),
  method.tau.ci = if (method.tau == "DL") "J" else "QP",
  prediction = FALSE,
  level.predict = level,
  method.predict = gs("method.predict"),
  adhoc.hakn.pi = gs("adhoc.hakn.pi"),
  backtransf = TRUE,
  pscale = 1,
  irscale = 1,
  irunit = "person-years",
  silent = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{meta}, or estimated treatment
effect in individual studies.}

\item{left}{A logical indicating whether studies are supposed to be
missing on the left or right side of the funnel plot. If NULL,
the linear regression test for funnel plot symmetry (i.e.,
function \code{metabias(..., method="Egger")}) is used to
determine whether studies are missing on the left or right side.}

\item{ma.common}{A logical indicating whether a common effect or
random effects model is used to estimate the number of missing
studies.}

\item{type}{A character indicating which method is used to estimate
the number of missing studies. Either \code{"L"} or \code{"R"}.}

\item{n.iter.max}{Maximum number of iterations to estimate number
of missing studies.}

\item{common}{A logical indicating whether a common effect
meta-analysis should be conducted.}

\item{random}{A logical indicating whether a random effects
meta-analysis should be conducted.}

\item{prediction}{A logical indicating whether a prediction
interval should be printed.}

\item{backtransf}{A logical indicating whether results should be
back transformed in printouts and plots. If
\code{backtransf=TRUE}, results for \code{sm="OR"} are printed as
odds ratios rather than log odds ratios and results for
\code{sm="ZCOR"} are printed as correlations rather than Fisher's
z transformed correlations, for example.}

\item{pscale}{A numeric giving scaling factor for printing of
single event probabilities or risk differences, i.e. if argument
\code{sm} is equal to \code{"PLOGIT"}, \code{"PLN"},
\code{"PRAW"}, \code{"PAS"}, \code{"PFT"}, or \code{"RD"}.}

\item{irscale}{A numeric defining a scaling factor for printing of
single incidence rates or incidence rate differences, i.e. if
argument \code{sm} is equal to \code{"IR"}, \code{"IRLN"},
\code{"IRS"}, \code{"IRFT"}, or \code{"IRD"}.}

\item{irunit}{A character specifying the time unit used to
calculate rates, e.g. person-years.}

\item{silent}{A logical indicating whether basic information on
iterations shown.}

\item{warn.deprecated}{A logical indicating whether warnings should
be printed if deprecated arguments are used.}

\item{\dots}{Additional arguments (to catch deprecated arguments).}

\item{seTE}{Standard error of estimated treatment effect.}

\item{sm}{An optional character string indicating underlying
summary measure, e.g., \code{"RD"}, \code{"RR"}, \code{"OR"},
\code{"ASD"}, \code{"HR"}, \code{"MD"}, \code{"SMD"}, or
\code{"ROM"}; ignored if \code{x} is of class \code{meta}.}

\item{studlab}{An optional vector with study labels; ignored if
\code{x} is of class \code{meta}.}

\item{level}{The level used to calculate confidence intervals for
individual studies. If existing, \code{x$level} is used as value
for \code{level}; otherwise 0.95 is used.}

\item{level.ma}{The level used to calculate confidence interval for
the pooled estimate. If existing, \code{x$level.ma} is used as
value for \code{level.ma}; otherwise 0.95 is used.}

\item{method.random.ci}{A character string indicating which method
is used to calculate confidence interval and test statistic for
random effects estimate (see \code{\link{meta-package}}).}

\item{adhoc.hakn.ci}{A character string indicating whether an
\emph{ad hoc} variance correction should be applied in the case
of an arbitrarily small Hartung-Knapp variance estimate (see
\code{\link{meta-package}}).}

\item{method.tau}{A character string indicating which method is
used to estimate the between-study variance \eqn{\tau^2} and its
square root \eqn{\tau} (see \code{\link{meta-package}}).}

\item{method.tau.ci}{A character string indicating which method is
used to estimate the confidence interval of \eqn{\tau^2} and
\eqn{\tau} (see \code{\link{meta-package}}).}

\item{level.predict}{The level used to calculate prediction
interval for a new study.}

\item{method.predict}{A character string indicating which method is
used to calculate a prediction interval (see
\code{\link{meta-package}}).}

\item{adhoc.hakn.pi}{A character string indicating whether an
\emph{ad hoc} variance correction should be applied for the
prediction interval (see \code{\link{meta-package}}).}
}
\value{
An object of class \code{c("trimfill", "metagen", "meta")} with
corresponding generic functions (see \code{\link{meta-object}}).
}
\description{
Trim-and-fill method for estimating and adjusting for the number
and outcomes of missing studies in a meta-analysis.
}
\details{
The trim-and-fill method (Duval, Tweedie 2000a, 2000b) can be used
for estimating and adjusting for the number and outcomes of missing
studies in a meta-analysis. The method relies on scrutiny of one
side of a funnel plot for asymmetry assumed due to publication
bias.

Three different methods have been proposed originally to estimate
the number of missing studies. Two of these methods (L- and
R-estimator) have been shown to perform better in simulations, and
are available in this R function (argument \code{type}).

A common effect or random effects model can be used to estimate the
number of missing studies (argument \code{ma.common}). Furthermore,
a common effect and/or random effects model can be used to
summaries study results (arguments \code{common} and
\code{random}). Simulation results (Peters et al. 2007) indicate
that the common-random model, i.e. using a common effect model to
estimate the number of missing studies and a random effects model
to summaries results, (i) performs better than the common-common
model, and (ii) performs no worse than and marginally better in
certain situations than the random-random model. Accordingly, the
common-random model is the default.

An empirical comparison of the trim-and-fill method and the Copas
selection model (Schwarzer et al. 2010) indicates that the
trim-and-fill method leads to excessively conservative inference in
practice. The Copas selection model is available in R package
\bold{metasens}.

The function \code{\link{metagen}} is called internally.
}
\examples{
data(Fleiss1993bin)
m1 <- metabin(d.asp, n.asp, d.plac, n.plac, data = Fleiss1993bin, sm = "OR")
tf1 <- trimfill(m1)
tf1
funnel(tf1)
funnel(tf1, pch = ifelse(tf1$trimfill, 1, 16), level = 0.9, random = FALSE)
#
# Use log odds ratios on x-axis
#
funnel(tf1, backtransf = FALSE)
funnel(tf1, pch = ifelse(tf1$trimfill, 1, 16), level = 0.9, random = FALSE,
  backtransf = FALSE)

trimfill(m1$TE, m1$seTE, sm = m1$sm)

}
\references{
Duval S & Tweedie R (2000a):
A nonparametric "Trim and Fill" method of accounting for
publication bias in meta-analysis.
\emph{Journal of the American Statistical Association},
\bold{95}, 89--98

Duval S & Tweedie R (2000b):
Trim and Fill: A simple funnel-plot-based method of testing and
adjusting for publication bias in meta-analysis.
\emph{Biometrics},
\bold{56}, 455--63

Peters JL, Sutton AJ, Jones DR, Abrams KR, Rushton L (2007):
Performance of the trim and fill method in the presence of
publication bias and between-study heterogeneity.
\emph{Statisics in Medicine},
\bold{10}, 4544--62

Schwarzer G, Carpenter J, Rücker G (2010):
Empirical evaluation suggests Copas selection model preferable to
trim-and-fill method for selection bias in meta-analysis
\emph{Journal of Clinical Epidemiology},
\bold{63}, 282--8
}
\seealso{
\code{\link{metagen}}, \code{\link{metabias}},
  \code{\link{funnel}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
