% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REtree.R
\name{REmrt}
\alias{REmrt}
\title{Random effects meta-tree}
\usage{
REmrt(formula, data, vi, c = 1, maxL = 10L, minsplit = 2L, delQ = 0.001,
  n.fold = 10, ...)
}
\arguments{
\item{formula}{A formula, with a response variable (usually the effect size) and the potential moderator variables but no interaction terms.}

\item{data}{A data frame of a meta-analytic data set, including the study effect sizes, sampling variance, and the potential moderators.}

\item{vi}{sampling variance of the effect size.}

\item{c}{A non-negative scalar.The pruning parameter to prune the initial tree by the "c*standard-error" rule.}

\item{maxL}{the maximum number of splits}

\item{minsplit}{the minimum number of studies in a parent node before splitting}

\item{delQ}{the stopping rule for the decrease of between-subgroups Q. Any split that does not decrease the between-subgroups Q is not attempted.}

\item{n.fold}{the number of folds to perform the cross-validation}

\item{...}{Additional arguments to be passed.}
}
\value{
If no moderator effect is detected, the function will return a list including the following objects:

n: The total number of the studies

Q: The Q-statistics for the heterogeneity test

df: The degree of freedoms of the heterogeneity test

pval.Q: The p-value for the heterogeneity test

g: The summary effect size for all studies (i.e., the overall effect size)

se: The standard error of the summary effect size

zval: The test statistic of the summary effect size

pval: The p-value for the test statistic of the summary effect size

ci.lb: The lower bound of the confidence interval for the summary effect size

ci.ub: The upper bound of the confidence interval for the summary effect size

call: The matched call

If  (a) moderator effect(s) is(are) detected, the function will return a list including the following objects:

tree: A data frame that represents the tree, with the Q-between and the residual heterogeneity (tau^2) after each split.

n: The number of the studies in each subgroup

moderators: the names of identified moderators

Qb: The between-subgroups Q-statistic

tau2: The estimate of the residual heterogeneity

df: The degrees of freedom of the between-subgroups Q test

pval.Qb: The p-value of the between-subgroups Q test

g: The subgroup summary effect size, based on Hedges'g

se: The standard error of subgroup summary effect size

zval: The test statistic of the subgroup summary effect size

pval: The p-value of the test statistic of the subgroup summary effect size

ci.lb: The lower bound of the confidence interval

ci.ub: The upper bound of the confidence interval

call: The matched call

cv.res: The cross-validation table

data: the data set subgrouped by the fitted tree
}
\description{
A function to fit a random effects meta-tree
}
\examples{
data(dat.BCT2009)
REtree <- REmrt(g ~ T1 + T2+ T4 +T25, vi = vi, data = dat.BCT2009, c = 0)
summary(REtree)
}
\seealso{
\code{\link{summary.REmrt}}, \code{\link{plot.REmrt}}
}
