% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PDF_download.R
\name{PDF_download}
\alias{PDF_download}
\title{Attempts to download a PDF using a DOI link.}
\usage{
PDF_download(
  DOI,
  directory = getwd(),
  theFileName = "temp",
  validatePDF = TRUE,
  quiet = FALSE,
  WindowsProxy = FALSE
)
}
\arguments{
\item{DOI}{A string of the DOI (digital object identifier) used to identify
the source of a journal article PDF file(s).}

\item{directory}{A string of the location (directory) were downloaded PDF
files are to be saved.  Directory name must end with "\\\\".}

\item{theFileName}{Used to rename the downloaded file.  No need to include
extension ".pdf".}

\item{validatePDF}{When \code{"TRUE"} will only save to files that are valid
PDF documents.  When \code{"FALSE"} will save all candidate files, even if
they are not valid PDF formats.}

\item{quiet}{When \code{"FALSE"} does not print to console download progress
and summary.}

\item{WindowsProxy}{When \code{TRUE} significantly improves download success
for computers running Windows; when \code{FALSE} on a Windows based
computer, you may only be able to download 30 to 50 PDFs at a time before
a connection error occurs and halts all downloads (e.g.,
\code{InternetOpenUrl failed} error).}
}
\value{
A string describing the download success.  If unsuccessful,
   returns the type of error during the download attempt.
}
\description{
Tries to download a PDF file using the digital objected identifier (DOI) link.
Uses ad hoc searches of journal HTML pages to detect candidate PDFs for
download.  Downloads all candidate pdfs. \strong{If running downloader
in Windows, having \code{"WindowsProxy = TRUE"} will significantly improve
download success.}
}
\seealso{
\code{\link{PDFs_collect}}
}
