% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxcomtab.show.R
\name{taxcomtab.show}
\alias{taxcomtab.show}
\title{Display abundance comparison results.}
\usage{
taxcomtab.show(taxcomtab, sumvar = "taxa", tax.lev = "l2",
  tax.select = "none", showvar, readjust.p = FALSE,
  p.adjust.method = "fdr", p.cutoff = 0.05, digit = 2, p.digit = 4)
}
\arguments{
\item{taxcomtab}{table of taxa abundance comparison generated from taxa.compare.}

\item{sumvar}{Options are "taxa" for bacterial taxa and "path" for pathway. Default is "taxa"}

\item{tax.lev}{taxa level to be displayed. Options are from "l2" (phylum) to "l7" (species). Default is "l2".}

\item{tax.select}{selected list of taxa to be displayed. Default is "none" or display all available taxa.}

\item{showvar}{variable (pattern) in the model to be displayed.}

\item{readjust.p}{multiple testing re-adjustment for only the level to be displayed (TRUE) or keep original multiple testing adjustment for all taxa of all levels (FALSE).}

\item{p.adjust.method}{method for multiple testing adjustment. Available options are those of the p.adjust function. Default is "fdr".}

\item{p.cutoff}{cutoff p-value to be displayed. Default is 0.05.}

\item{digit}{digit for estimates and 95 CI. Default is 2.}

\item{p.digit}{digit for p-values. Default is 4.}
}
\value{
a table of results.
}
\description{
This function displays taxa/pathway abundance comparison results as table.
}
\examples{
#Load summary tables of bacterial taxa relative abundance from Bangladesh data
data(taxtab6)
#Comparison of bacterial taxa relative abundance using GAMLSS
# Only run on a few taxa of a phylum to save running time
tl<-colnames(taxtab6)[grep("k__bacteria.p__fusobacteria",colnames(taxtab6))]
taxacom.ex<-taxa.compare(taxtab=taxtab6[,c("personid","x.sampleid","bf","age.sample",tl)],
propmed.rel="gamlss",comvar="bf",adjustvar="age.sample",
longitudinal="yes",p.adjust.method="fdr")
# show phylum results
taxcomtab.show(taxcomtab=taxacom.ex,tax.select="none",
showvar="bfNon_exclusiveBF", tax.lev="l2",
readjust.p=TRUE,p.adjust.method="fdr",p.cutoff = 1)
}
\keyword{abundance}
\keyword{comparison}
\keyword{display.}
