% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_covmat.R
\name{get_covmat}
\alias{get_covmat}
\title{Generate a covariance matrix}
\usage{
get_covmat(cormat, var)
}
\arguments{
\item{cormat}{A symmetric matrix with desired correlations.}

\item{var}{A numeric vector with variances. It must have length equal to the
number of elements in the diagonal of \code{cormat}.}
}
\value{
A (co)variance matrix
}
\description{
Given the variances and desired correlations, generate a covariance matrix
}
\examples{
\donttest{
cormat <-
matrix(c(1,  0.9, -0.4,
         0.9,  1,  0.6,
        -0.4, 0.6, 1),
      nrow = 3,
      ncol = 3)
get_covmat(cormat, var =  c(16, 25, 9))
}

}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
