% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ge_simula.R
\name{ge_simula}
\alias{ge_simula}
\title{Simulate genotype-environment data}
\usage{
ge_simula(
  ngen,
  nenv,
  nrep,
  nvars = 1,
  gen_eff = 20,
  env_eff = 15,
  rep_eff = 5,
  ge_eff = 10,
  intercept = 100,
  seed = NULL
)
}
\arguments{
\item{ngen}{The number of genotypes.}

\item{nenv}{The number of environments.}

\item{nrep}{The number of replications.}

\item{nvars}{The number of traits.}

\item{gen_eff}{The genotype effect.}

\item{env_eff}{The environment effect}

\item{rep_eff}{The replication effect}

\item{ge_eff}{The genotype-environment interaction effect.}

\item{intercept}{The intercept.}

\item{seed}{The seed.}
}
\value{
A data frame with the simulated traits
}
\description{
Simulate genotype-environment data given a desired number of genotypes,
environments and effects.
}
\details{
Genotype, environment and genotype-environment interaction effects are
sampled from an uniform distribution. For example, given 10 genotypes, and
\code{gen_eff = 30}, the genotype effects will be sampled as \code{runif(10, min = -30, max = 30)}. Use the argument \code{seed} to ensure reproducibility. If more than
one trait is used (\code{nvars > 1}), the effects and seed can be passed as a
numeric vector. Single numeric values will be recycled with a warning when
more than one trait is used.
}
\examples{
\donttest{
library(metan)
df <-
ge_simula(ngen = 10,
          nenv = 3,
          nrep = 4,
          nvars = 2)
inspect(df, plot = TRUE)

# Change genotype effect (trait 1 with fewer differences among genotypes)
# Define different intercepts for the two traits
df2 <-
ge_simula(ngen = 10,
          nenv = 3,
          nrep = 4,
          nvars = 2,
          gen_eff = c(1, 50),
          intercept = c(80, 1500))
inspect(df2, plot = TRUE)
}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
