% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coincidence_index.R
\name{coincidence_index}
\alias{coincidence_index}
\title{Computes the coincidence index of genotype selection}
\usage{
coincidence_index(..., total, sel1 = NULL, sel2 = NULL)
}
\arguments{
\item{...}{A comma-separated list of objects of class \code{mgidi},
\code{mtsi} \code{fai_blup}, or \code{sh}. When a model is informed, then
the selected genotypes are extracted automatically.}

\item{total}{The total number of genotypes in the study.}

\item{sel1, sel2}{The selected genotypes by the method 1 and 2, respectively. Defaults to \code{NULL}.}
}
\value{
A list with the following elements:
\itemize{
\item \strong{coincidence}: A data frame with the coincidence index, number of
common genotypes and the list of common genotypes for each model combination.
\item \strong{coincidence_mat}: A matrix-like containing the coincidence index.
\item \strong{genotypes}: The number of common genotypes for all models, i.e.,
the insersection of the selected genotypes of all models
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Computes the coincidence index (Hamblin and Zimmermann, 1986) as follows:

\loadmathjax
\mjsdeqn{CI = \frac{A-C}{M-C}\times 100}
where \emph{A} is the number of selected genotypes common to different
methods; \emph{C} is the number of expected genotypes selected by chance; and
\emph{M} is the number of genotypes selected according to the selection
intensity.
}
\examples{
\donttest{
sel1 <- paste("G", 1:30, sep = "")
sel2 <- paste("G", 16:45, sep = "")
coincidence_index(sel1 = sel1, sel2 = sel2, total = 150)
}
}
\references{
Hamblin, J., and M.J. de O. Zimmermann. 1986. Breeding Common Bean for Yield
in Mixtures. p. 245-272. In Plant Breeding Reviews. John Wiley & Sons, Inc.,
Hoboken, NJ, USA.\doi{10.1002/9781118061015.ch8}
}
