% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WAASB.R
\name{print.waasb}
\alias{print.waasb}
\title{Print an object of class waasb}
\usage{
\method{print}{waasb}(x, export = FALSE, blup = FALSE, file.name = NULL, digits = 4, ...)
}
\arguments{
\item{x}{An object of class \code{waasb}.}

\item{export}{A logical argument. If \code{TRUE|T}, a *.txt file is exported
to the working directory}

\item{blup}{A logical argument. If \code{TRUE|T}, the blups are shown.}

\item{file.name}{The name of the file if \code{export = TRUE}}

\item{digits}{The significant digits to be shown.}

\item{...}{Options used by the tibble package to format the output. See
\code{\link[tibble:formatting]{tibble::print()}} for more details.}
}
\description{
Print a \code{waasb} object in two ways. By default, the results are shown in
the R console. The results can also be exported to the directory.
}
\examples{
\donttest{
library(metan)
model <- waasb(data_ge,
  resp = c(GY, HM),
  gen = GEN,
  env = ENV,
  rep = REP
)
print(model)
}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
