% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.limitmeta.R
\name{print.limitmeta}
\alias{print.limitmeta}
\title{Print method for limit meta-analysis}
\usage{
\method{print}{limitmeta}(
  x,
  sortvar,
  backtransf = x$backtransf,
  digits = gs("digits"),
  big.mark = gs("big.mark"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{limitmeta}}

\item{sortvar}{An optional vector used to sort the individual
studies (must be of same length as \code{x$TE}).}

\item{backtransf}{A logical indicating whether results should be
back transformed in printouts and plots. If
\code{backtransf=TRUE} (default), results for \code{sm="OR"} are
printed as odds ratios rather than log odds ratio, for example.}

\item{digits}{Minimal number of significant digits, see
\code{print.default}.}

\item{big.mark}{A character used as thousands separator.}

\item{\dots}{Additional arguments which are
passed on to \code{print.summary.limitmeta} called internally.}
}
\description{
Print method for objects of class \code{limitmeta}.
}
\details{
This function prints the summary information from
\code{summary.limitmeta} together with the following study
information:

\itemize{
\item Effect estimate with confidence interval
\item Shrunken effect estimates with confidence interval
}
}
\examples{
data(Moore1998)
m1 <- metabin(succ.e, nobs.e, succ.c, nobs.c,
              data = Moore1998, sm = "OR", method = "Inverse")

print(limitmeta(m1), digits = 2)

}
\seealso{
\code{\link{limitmeta}}, \code{\link{summary.limitmeta}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
\keyword{print}
