% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doiplot.R
\name{doiplot}
\alias{doiplot}
\title{Doi plot for Asymmetry}
\usage{
doiplot(
  TE,
  seTE,
  xlim,
  ylim,
  xlab = NULL,
  ylab = "|Z-score|",
  lfkindex = TRUE,
  pos.lfkindex = "topleft",
  ...
)
}
\arguments{
\item{TE}{An object of class \code{lfkindex} or \code{meta} or
estimated treatment effect in individual studies.}

\item{seTE}{Standard error of estimated treatment effect (mandatory
if \code{TE} not of class \code{lfkindex} or \code{meta}).}

\item{xlim}{The x limits (min,max) of the plot.}

\item{ylim}{The y limits (min,max) of the plot.}

\item{xlab}{A label for the x-axis.}

\item{ylab}{A label for the y-axis.}

\item{lfkindex}{A logical indicating whether LFK index should be
printed.}

\item{pos.lfkindex}{A character string with position of text with
LFK index (see \code{\link{legend}}).}

\item{\dots}{Additional arguments (passed on to
\code{\link{plot.default}}).}
}
\description{
Implementation of the Doi plot proposed by Furuya-Kanamori
et al. (2018) to evaluate bias in meta-analysis.
}
\examples{
# Example from Furuya-Kanamori et al. (2018)
#
pain <- data.frame(SMD = c(-4.270, -1.710, -0.580, -0.190, 0.000),
                   varSMD = c(0.158,  0.076,  0.018,  0.022, 0.040))

lfk.pain <- lfkindex(SMD, sqrt(varSMD), data = pain)
lfk.pain

doiplot(lfk.pain)

}
\references{
Furuya-Kanamori L, Barendregt JJ, Doi SAR (2018):
A new improved graphical and quantitative method for detecting bias
in meta-analysis.
\emph{International Journal of Evidence-Based Healthcare},
\bold{16}, 195--203
}
\seealso{
\code{\link{lfkindex}}, \code{\link{metabias}},
  \code{\link{funnel.meta}}
}
\author{
Gerta Rücker \email{gerta.ruecker@uniklinik-freiburg.de}, Guido
  Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
