% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coclustering.R
\name{batch_snf_subsamples}
\alias{batch_snf_subsamples}
\title{Run SNF clustering pipeline on a list of subsampled data lists.}
\usage{
batch_snf_subsamples(
  dl_subsamples,
  sc,
  processes = 1,
  return_sim_mats = FALSE,
  sim_mats_dir = NULL,
  verbose = TRUE
)
}
\arguments{
\item{dl_subsamples}{A list of subsampled data lists. This object is
generated by the function \code{batch_snf_subsamples()}.}

\item{sc}{An \code{snf_config} class object which stores all sets of
hyperparameters used to transform data in dl into a cluster solutions. See
\code{?settings_df} or
https://branchlab.github.io/metasnf/articles/settings_df.html for more
details.}

\item{processes}{Specify number of processes used to complete SNF iterations
\itemize{
\item \code{1} (default) Sequential processing: function will iterate through the
\code{settings_df} one row at a time with a for loop. This option will
not make use of multiple CPU cores, but will show a progress bar.
\item \code{2} or higher: Parallel processing will use the
\code{future.apply::future_apply} to distribute the SNF iterations across
the specified number of CPU cores. If higher than the number of
available cores, a warning will be raised and the maximum number of
cores will be used.
\item \code{max}: All available cores will be used.
}}

\item{return_sim_mats}{If TRUE, function will return a list where
the first element is the solutions data frame and the second element is a list
of similarity matrices for each row in the sol_df. Default FALSE.}

\item{sim_mats_dir}{If specified, this directory will be used to
save all generated similarity matrices.}

\item{verbose}{If TRUE, output progress to console.}
}
\value{
By default, returns a one-element list: \code{cluster_solutions}, which
is itself a list of cluster solution data frames corresponding to each of
the provided data list subsamples. Setting the parameters
\code{return_sim_mats}  and \code{return_solutions} to \code{TRUE}
will turn the result of the function to a three-element list containing the
corresponding solutions data frames and final fused similarity matrices of
those cluster solutions, should you require these objects for your own
stability calculations.
}
\description{
Run SNF clustering pipeline on a list of subsampled data lists.
}
\examples{
# my_dl <- data_list(
#     list(subc_v, "subcortical_volume", "neuroimaging", "continuous"),
#     list(income, "household_income", "demographics", "continuous"),
#     list(pubertal, "pubertal_status", "demographics", "continuous"),
#     uid = "unique_id"
# )
# 
# sc <- snf_config(my_dl, n_solutions = 5, max_k = 40)
# 
# my_dl_subsamples <- subsample_dl(
#     my_dl,
#     n_subsamples = 20,
#     subsample_fraction = 0.85
# )
# 
# batch_subsample_results <- batch_snf_subsamples(
#     my_dl_subsamples,
#     sc,
#     verbose = TRUE
# )
}
