% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel.R
\name{batch_row_closure}
\alias{batch_row_closure}
\title{Generate closure function to run batch_snf in an apply-friendly format}
\usage{
batch_row_closure(
  dl,
  dfl,
  cfl,
  sdf,
  wm,
  similarity_matrix_dir,
  return_sim_mats,
  prog
)
}
\arguments{
\item{dl}{A nested list of input data from \code{data_list()}.}

\item{dfl}{An optional nested list containing which
distance metric function should be used for the various feature types
(continuous, discrete, ordinal, categorical, and mixed). See
?dist_fns_list for details on how to build this.}

\item{cfl}{List of custom clustering algorithms to apply
to the final fused network. See ?clust_fns_list.}

\item{sdf}{matrix indicating parameters to iterate SNF through.}

\item{wm}{A matrix containing feature weights to use during
distance matrix calculation. See ?weights_matrix for details on
how to build this.}

\item{similarity_matrix_dir}{If specified, this directory will be used to
save all generated similarity matrices.}

\item{return_sim_mats}{If TRUE, function will return a list where
the first element is the solutions data frame and the second element is a list
of similarity matrices for each row in the sol_df. Default FALSE.}

\item{prog}{Progressr function to update parallel processing progress}
}
\value{
A "function" class object used to run \code{batch_snf} in lapply-form
for parallel processing.
}
\description{
Generate closure function to run batch_snf in an apply-friendly format
}
\keyword{internal}
