% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_propagation.R
\name{label_prop}
\alias{label_prop}
\title{Label propagation}
\usage{
label_prop(full_fused_network, clusters)
}
\arguments{
\item{full_fused_network}{A network made by running SNF on training and test
observations together.}

\item{clusters}{A vector of assigned clusters for training observations in
matching order as they appear in full_fused_network.}
}
\value{
A list of cluster labels for all observations.
}
\description{
Given a full fused network (one containing both pre-clustered observations
and to-be-clustered observations) and the clusters of the pre-clustered
observations, return a label propagated list of clusters for all observations.
This function is derived from SNFtool::groupPredict. Modifications are made
to take a full fused network as input, rather than taking input data frames
and running SNF internally. This ensures that alternative approaches to
data normalization and distance matrix calculations can be chosen by the
user.
}
\keyword{internal}
