% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_currentday.R, R/download_stationlist.R
\name{downloadMETEOCLIMATICcurrentday}
\alias{downloadMETEOCLIMATICcurrentday}
\alias{downloadMETEOCLIMATICstationlist}
\title{Download data from Meteoclimatic network}
\usage{
downloadMETEOCLIMATICcurrentday(station_id = "ESCAT")

downloadMETEOCLIMATICstationlist(station_id = "ESCAT")
}
\arguments{
\item{station_id}{A string vector containing station ids (the list of
stations for which current day climatic data is available is given by
\code{downloadMETEOCLIMATICstationlist}). By default, returns the list of
stations in Catalonia.}
}
\value{
Function \code{downloadMETEOCLIMATICstationlist} returns a
\code{SpatialPointsDataFrame} object containing the list of
Meteoclimatic weather stations for which data is available based on the
station_id codes provided.

Function \code{downloadMETEOCLIMATICcurrentday} downloads recent weather
(for the current day) from all currently available stations and returns a
\code{SpatialPointsDataFrame} object with observations. Only
accumulated precipitation, maximum and minimum temperature and relative
humidity are returned.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Download data from the Spanish Automatic Stations Network
(non-professional)
}
\details{
Meteoclimatic is a non-professional automatic stations network, maintained
by volunteers that share the data from their climatic stations. Data offered
by these stations has not passed any quality control.
}
\section{Functions}{
\itemize{
\item \code{downloadMETEOCLIMATICstationlist()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

}}
\note{
Since ver. 1.0.1, weather data download functions included in
\code{meteoland} make internal calls to functions in package
\code{meteospain}. For an enhanced flexibility, users are recommended to
call functions in \code{meteospain} themselves, and then to use function
\code{\link{reshapemeteospain}} to generate data suitable for
\code{meteoland}.
}
\references{
Meteoclimatic should be acknowledged as author of information
when using this data.
}
\seealso{
\code{\link{SpatialPointsMeteorology-class}}
}
\author{
Víctor Granda, EMF-CREAF

Miquel De \enc{Cáceres}{Caceres} Ainsa, EMF-CREAF
}
