% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meteoplot.R
\name{meteoplot}
\alias{meteoplot}
\title{Plots point meteorological series}
\usage{
meteoplot(
  object,
  index = 1,
  var = "MeanTemperature",
  fun = NULL,
  freq = NULL,
  dates = NULL,
  months = NULL,
  add = FALSE,
  ...
)
}
\arguments{
\item{object}{A data frame with daily meteorological data (in this case
\code{index} is not used) or an object of class
\code{\linkS4class{SpatialPointsMeteorology}}. Alternatively, an object of
class \code{SpatialPointsDataFrame} containing the meta data
(columns \code{dir}, \code{filename} and possibly \code{format}) of
meteorological files.}

\item{index}{An integer to indicate the point in the
\code{\linkS4class{SpatialPointsMeteorology}} object (or the
\code{SpatialPointsDataFrame} object).}

\item{var}{The meteorological variable to be plotted.}

\item{fun}{The name of a function to be calculated for summaries (only valid
if \code{freq} is specified).}

\item{freq}{A string giving an interval specification for summaries (e.g.,
\code{"week"}, \code{"month"}, \code{"quarter"} or \code{"year"}).}

\item{dates}{An object of class \code{\link{Date}} to define the period to
be plotted. If \code{dates = NULL} then all dates in \code{object} are
processed.}

\item{months}{A numeric vector to indicate the subset of months for which
plotting is desired (e.g. \code{c(7,8)} for July and August). When combined
with \code{fun} and \code{freq}, this parameter allows plotting summaries
for particular seasons. For example \code{fun = "sum"} \code{freq = "years"}
and \code{months = 6:8} leads to plotting the sum over summer months of each
year.}

\item{add}{A flag to indicate wether drawing should be done on the current
plot (using function \code{lines}).}

\item{...}{Additional parameters for functions \code{plot} or \code{lines}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Simple plotting of a meteorological series for a given point.
}
\details{
Daily precipitation is plotted using bars (i.e. \code{type = "h"} when
calling \code{\link{plot}}). Otherwise the function draws lines (i.e.
\code{type = "l"} when calling \code{\link{plot}}). If \code{object} is of
class \code{SpatialPointsDataFrame} then the function reads the
meteorological data to be plotted from the disk.
}
\seealso{
\code{\link{summarypoints}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
