% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_iqRMSE.R
\name{iqRMSE}
\alias{iqRMSE}
\title{Inter-Quartile Root Mean Squared Error}
\usage{
iqRMSE(data = NULL, obs, pred, tidy = FALSE, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{tidy}{Logical operator (TRUE/FALSE) to decide the type of return. TRUE
returns a data.frame, FALSE returns a list; Default : FALSE.}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric} within a \code{list} (if tidy = FALSE) or within a
\verb{data frame} (if tidy = TRUE).
}
\description{
It estimates the IqRMSE for a continuous predicted-observed dataset.
}
\details{
The iqRMSE normalizes the RMSE by the length of the inter-quartile range of
observations (percentiles 25th to 75th). As an error metric, the lower the values the better.
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics_regression.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- X + rnorm(n=100, mean = 0, sd = 3)
iqRMSE(obs = X, pred = Y)
}
}
