% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_khat.R
\name{khat}
\alias{khat}
\title{K-hat (Cohen's Kappa Coefficient)}
\usage{
khat(data = NULL, obs, pred, pos_level = 2, tidy = FALSE, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (character | factor).}

\item{pred}{Vector with predicted values (character | factor).}

\item{pos_level}{Integer, for binary cases, indicating the order (1|2) of the level
corresponding to the positive. Generally, the positive level is the second (2)
since following an alpha-numeric order, the most common pairs are
\code{(Negative | Positive)}, \code{(0 | 1)}, \code{(FALSE | TRUE)}. Default : 2.}

\item{tidy}{Logical operator (TRUE/FALSE) to decide the type of return. TRUE
returns a data.frame, FALSE returns a list; Default : FALSE.}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric} within a \code{list} (if tidy = FALSE) or within a
\verb{data frame} (if tidy = TRUE).
}
\description{
It estimates the Cohen's Kappa Coefficient for a nominal/categorical
predicted-observed dataset.
}
\details{
The Cohen's Kappa Coefficient is the accuracy normalized by the possibility
of agreement by chance. Thus, it is considered a more robust agreement measure than
simply the accuracy. The kappa coefficient was originally described for evaluating
agreement of classification between different "raters" (inter-rater reliability).

It is positively bounded to 1, but it is not negatively bounded.
The closer to 1 the better as Kappa assumes its theoretical maximum value of 1
(perfect agreement) only when both observed and predicted values are equally
distributed across the classes (i.e. identical row and column sums). Thus,
the lower the kappa the lower the prediction quality.

For the formula and more details, see
\href{https://adriancorrendo.github.io/metrica/articles/available_metrics_classification.html}{online-documentation}
}
\examples{
\donttest{
set.seed(123)
# Two-class
binomial_case <- data.frame(labels = sample(c("True","False"), 100, replace = TRUE), 
predictions = sample(c("True","False"), 100, replace = TRUE))
# Multi-class
multinomial_case <- data.frame(labels = sample(c("Red","Blue", "Green"), 100, 
replace = TRUE), predictions = sample(c("Red","Blue", "Green"), 100, replace = TRUE))

# Get Cohen's Kappa Coefficient estimate for two-class case
khat(data = binomial_case, obs = labels, pred = predictions, tidy = TRUE)

# Get Cohen's Kappa Coefficient estimate for each class for the multi-class case
khat(data = multinomial_case, obs = labels, pred = predictions, tidy = TRUE)

# Get Cohen's Kappa Coefficient estimate for the multi-class case at a global level
khat(data = multinomial_case, obs = labels, pred = predictions, tidy = TRUE)
}
}
\references{
Cohen, J. (1960).
A coefficient of agreement for nominal scales.
_ Educational and Psychological Measurement 20 (1): 37–46._
\doi{10.1177/001316446002000104}
}
