% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate.r
\name{mjs_add_baseline}
\alias{mjs_add_baseline}
\title{Sets a baseline line/label}
\usage{
mjs_add_baseline(mjs, y_value, label)
}
\arguments{
\item{mjs}{metricsgraphics plot object}

\item{y_value}{which y value to draw the baseline at}

\item{label}{text label for the marker}
}
\value{
metricsgraphics object
}
\description{
metricsgraphics baselines are horizontal lines that may specify, say, a goal
or target to be reached. This function lets you add baselines to a plot object.
you can add as many as you need to.
}
\examples{
data.frame(
  year=seq(1790, 1970, 10),
  uspop=as.numeric(uspop)
) \%>\%
  mjs_plot(x=year, y=uspop) \%>\%
  mjs_line() \%>\%
  mjs_add_marker(1850, "Something Wonderful") \%>\%
  mjs_add_baseline(150, "Something Awful")
}

