% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate.r
\name{mjs_add_confidence_band}
\alias{mjs_add_confidence_band}
\title{Add a confidence band to line plot}
\usage{
mjs_add_confidence_band(mjs, lower_accessor = "l", upper_accessor = "u")
}
\arguments{
\item{mjs}{metricsgraphics plot object}

\item{lower_accessor}{bare or quoted name of column to use for the lower
bound of the confidence band}

\item{upper_accessor}{bare or quoted name of column to use for the upper
boudn of the confidence band}
}
\description{
If you have lower & upper points associated with your line in a data frame,
you can specify their accessors (defaults to \code{"l"} & \code{"u"}) here
which will result in a shaded confidence band being plotted with the line.
}
\examples{
require(binom)
require(dplyr)

set.seed(1492)
binom.confint(x=sample(2:30, 100, replace=TRUE), n = 100, tol = 1e-8,
              methods="bayes") \%>\%
  mutate(x=1:100) -> bdat

bdat \%>\%
  mjs_plot(x=x, y=mean, width=600, height=240) \%>\%
  mjs_axis_x(show_secondary_x_label=FALSE,
             extended_ticks=TRUE) \%>\%
  mjs_line() \%>\%
  mjs_add_confidence_band(lower_accessor="lower",
                          upper_accessor="upper")
}

