% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icbrio_ind.R
\name{icbrio_ind}
\alias{icbrio_ind}
\title{ICBrio index}
\usage{
icbrio_ind(dataset, store = FALSE, dec_c = ".", verbose = FALSE)
}
\arguments{
\item{dataset}{A data.frame obtained from \code{read_data}.}

\item{store}{A logical value indicating if the user want to store the results in a file.}

\item{dec_c}{A character used for decimal separator on results file.}

\item{verbose}{A logical value indicating indicating if progress messages should be given.}
}
\value{
This function returns a list with the following components:
\item{Icbrio_n}{The numerical ICBrio index (Kuhlmann et al. 2012).}
\item{Icbrio_c}{The ICBrio water quality class (Kuhlmann et al. 2012).}
}
\description{
Calculate ICBrio index
}
\details{
ICBrio was created to monitor the quality of inland waters in the state of São Paulo. It is a multimetric index that includes different metrics: richness, Shannon-Wiener diversity index (H’), Sequential Comparison index (ICS), Tanytarsini/Chironomidae ratio, richness of sensitive taxa and dominance of tolerant groups. Only one of the diversity indices (H’ or ICS) is considered to calculate it (in this case, the function H’ from 'vegan' package). The final value, which generates the diagnosis or classification of habitat quality, combines the arithmetic mean of the value obtained with the sum of the points of each metric.
}
\examples{

#Example data is a properly formatted table with richness measures of two sites
example_data

#Run icbrio_ind with that example_data
icb<-icbrio_ind(example_data)

#Check results
icb$Icbrio_n
icb$Icbrio_c
}
\references{
\itemize{
\item{Kuhlmann M, Imbimbo HV, Ogura LL (2012) <https://cetesb.sp.gov.br/aguas-interiores/wp-content/uploads/sites/12/2013/11/protocolo-biomonitoramento-2012.pdf>}
}
}
\seealso{
\link[metrix]{read_data}, \link{biotic_ind}
}
\author{
Juan Manuel Cabrera and Julieta Capeleti.
}
