% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restricted.mean.R
\name{resmeanATE}
\alias{resmeanATE}
\alias{rmstATE}
\alias{ratioATE}
\title{Average Treatment effect for Restricted Mean for censored competing risks data using IPCW}
\usage{
resmeanATE(formula, data, model = "exp", outcome = c("rmst", "rmtl"), ...)
}
\arguments{
\item{formula}{formula with 'Event' outcome}

\item{data}{data-frame}

\item{model}{exp ("exp") or identity link ("lin")}

\item{outcome}{restricted mean time (rmst) or restricted mean time lost (rmtl)}

\item{...}{Additional arguments to pass to binregATE}
}
\description{
Under the standard causal assumptions  we can estimate the average treatment effect E(Y(1) - Y(0)). We need Consistency, ignorability ( Y(1), Y(0) indep A given X), and positivity.
}
\details{
The first covariate in the specification of the competing risks regression model must be the treatment effect that is a factor. If the factor has more than two levels
then it uses the mlogit for propensity score modelling.  We consider the outcome mint(T;tau) or  I(epsion==cause1)(t- min(T;t)) that gives years lost due to cause "cause" depending on 
the number of causes. The default model is the exp(X^ beta) and otherwise a linear model is used. 

Estimates the ATE using the the standard binary double robust estimating equations that are IPCW censoring adjusted.
}
\examples{
library(mets); data(bmt); bmt$event <- bmt$cause!=0; dfactor(bmt) <- tcell~tcell
out <- resmeanATE(Event(time,event)~tcell+platelet,data=bmt,time=40,treat.model=tcell~platelet)
summary(out)

out1 <- resmeanATE(Event(time,cause)~tcell+platelet,data=bmt,cause=1,time=40,
                   treat.model=tcell~platelet)
summary(out1)

ratioATE(out,out1,h=function(x) log(x))
}
\author{
Thomas Scheike
}
