% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{gpd.tem}
\alias{gpd.tem}
\title{Tangent exponential model approximation for the GP distribution}
\usage{
gpd.tem(
  dat,
  param = c("scale", "shape", "quant", "VaR", "ES", "Nmean", "Nquant"),
  psi = NULL,
  m = NULL,
  threshold = 0,
  n.psi = 50,
  N = NULL,
  p = NULL,
  q = NULL,
  plot = FALSE,
  correction = TRUE
)
}
\arguments{
\item{dat}{sample vector for the GP distribution}

\item{param}{parameter over which to profile}

\item{psi}{scalar or ordered vector of values for the interest parameter. If \code{NULL} (default), a grid of values centered at the MLE is selected. If \code{psi} is of length 2 and \code{n.psi}>2, it is assumed to be the minimal and maximal values at which to evaluate the profile log likelihood.}

\item{m}{number of observations of interest for return levels. See \strong{Details}. Required only for \code{param = 'VaR'} or \code{param = 'ES'}.}

\item{threshold}{threshold value corresponding to the lower bound of the support or the location parameter of the generalized Pareto distribution.}

\item{n.psi}{number of values of \code{psi} at which the likelihood is computed, if \code{psi} is not supplied (\code{NULL}). Odd values are more prone to give rise to numerical instabilities near the MLE}

\item{N}{size of block over which to take maxima. Required only for \code{args} \code{Nmean} and \code{Nquant}.}

\item{p}{tail probability, equivalent to \eqn{1/m}. Required only for \code{args} \code{quant}.}

\item{q}{level of quantile for N-block maxima. Required only for \code{args} \code{Nquant}.}

\item{plot}{logical indicating whether \code{plot.fr} should be called upon exit}

\item{correction}{logical indicating whether \link{spline.corr} should be called.}
}
\value{
an invisible object of class \code{fr} (see \code{tem} in package \code{hoa}) with elements
\itemize{
\item \code{normal}: maximum likelihood estimate and standard error of the interest parameter \eqn{\psi}
\item \code{par.hat}: maximum likelihood estimates
\item \code{par.hat.se}: standard errors of maximum likelihood estimates
\item \code{th.rest}: estimated maximum profile likelihood at (\eqn{\psi}, \eqn{\hat{\lambda}})
\item \code{r}: values of likelihood root corresponding to \eqn{\psi}
\item \code{psi}: vector of interest parameter
\item \code{q}: vector of likelihood modifications
\item \code{rstar}: modified likelihood root vector
\item \code{rstar.old}: uncorrected modified likelihood root vector
\item \code{param}: parameter
}
}
\description{
The function \code{gpd.tem} provides a tangent exponential model (TEM) approximation
for higher order likelihood inference for a scalar parameter for the generalized Pareto distribution. Options include
scale and shape parameters as well as value-at-risk (also referred to as quantiles, or return levels)
and expected shortfall. The function attempts to find good values for \code{psi} that will
cover the range of options, but the fit may fail and return an error. In such cases, the user can try to find good
grid of starting values and provide them to the routine.
}
\details{
As of version 1.11, this function is a wrapper around \code{gpd.pll}.

The interpretation for \code{m} is as follows: if there are on average \eqn{m_y} observations per year above the threshold, then  \eqn{m = Tm_y} corresponds to \eqn{T}-year return level.
}
\examples{
set.seed(123)
dat <- rgp(n = 40, scale = 1, shape = -0.1)
#with plots
m1 <- gpd.tem(param = 'shape', n.psi = 50, dat = dat, plot = TRUE)
\dontrun{
m2 <- gpd.tem(param = 'scale', n.psi = 50, dat = dat)
m3 <- gpd.tem(param = 'VaR', n.psi = 50, dat = dat, m = 100)
#Providing psi
psi <- c(seq(2, 5, length = 15), seq(5, 35, length = 45))
m4 <- gpd.tem(param = 'ES', dat = dat, m = 100, psi = psi, correction = FALSE)
mev:::plot.fr(m4, which = c(2, 4))
plot(fr4 <- spline.corr(m4))
confint(m1)
confint(m4, parm = 2, warn = FALSE)
m5 <- gpd.tem(param = 'Nmean', dat = dat, N = 100, psi = psi, correction = FALSE)
m6 <- gpd.tem(param = 'Nquant', dat = dat, N = 100, q = 0.7, correction = FALSE)
}
}
\author{
Leo Belzile
}
