% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tem.R
\name{confint.fr}
\alias{confint.fr}
\title{Confidence intervals for profile likelihood derived from TEM}
\usage{
\method{confint}{fr}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{an object of class \code{fr}, normally the output of \link{gpd.tem} or \link{gev.tem}.}

\item{parm}{a specification of which parameters are to be given confidence intervals, either a vector of numbers or a vector of names. If missing, all parameters are considered.}

\item{level}{confidence level, with default 0.95}

\item{...}{additional arguments passed to functions. Providing a logical \code{warn=FALSE} turns off warning messages when the lower or upper confidence interval for \code{psi} are extrapolated beyond the provided calculations.}
}
\value{
a 2 by 3 matrix containing point estimates, lower and upper confidence intervals based on \code{r} and \code{rstar}
}
\description{
This function uses spline interpolation to derive \code{level} confidence intervals
using the output of either \link{gev.tem} or \link{gpd.tem}.
}

