% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tailindex.R
\name{fit.shape}
\alias{fit.shape}
\title{Shape parameter estimates}
\usage{
fit.shape(
  xdat,
  k,
  method = c("hill", "rbm", "osz", "vries", "genjack", "mom", "dekkers", "genquant",
    "pickands", "erm"),
  ...
)
}
\arguments{
\item{xdat}{vector of positive observations of length \eqn{n}}

\item{k}{number of largest order statistics}

\item{method}{estimation method.}

\item{...}{additional parameters passed to functions}
}
\value{
a data frame with the number of order statistics \code{k} and the shape parameter estimate \code{shape}, or a single numeric value if \code{k} is a scalar.
}
\description{
Wrapper to estimate the tail index or shape parameter of an extreme value distribution. Each function has similar sets of arguments, a vector or scalar number of order statistics \code{k} and
a vector of positive observations \code{xdat}. The \code{method} argument allows users to choose between different indicators, including the Hill estimator (\code{hill}, for positive observations and shape only), the moment estimator of Dekkers and de Haan (\code{mom} or \code{dekkers}), the de Vries estimator of de Haan and Peng (\code{vries}), the generalized jackknife estimator of Gomes et al. (\code{genjack}), the Beirlant, Vynckier and Teugels generalized quantile estimator (\code{bvt} or \code{genquant}), the Pickands estimator (\code{pickands}), the extreme \eqn{U}-statistics estimator of Oorschot, Segers and Zhou (\code{osz}), or the exponential rgression model of Beirlant et al. (\code{erm}).
}
