% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tailindex.R
\name{rho.fagh}
\alias{rho.fagh}
\title{Second order tail index estimator of Fraga Alves et al.
Estimator of the second order regular variation parameter \eqn{\rho \leq 0} parameter for heavy-tailed data proposed by Fraga Alves et al. (2003)}
\usage{
rho.fagh(xdat, k, tau = 0)
}
\arguments{
\item{xdat}{vector of positive observations}

\item{k}{number of highest order statistics to use for estimation}

\item{tau}{scalar real tuning parameter. Default values is 0, which is typically chosen whenever \eqn{\rho \ge -1}. The choice \eqn{\tau=1} otherwise.}
}
\description{
Second order tail index estimator of Fraga Alves et al.
Estimator of the second order regular variation parameter \eqn{\rho \leq 0} parameter for heavy-tailed data proposed by Fraga Alves et al. (2003)
}
\examples{
# Example with rho = -0.2
n <- 1000
xdat <- mev::rgp(n = n, shape = 0.2)
kmin <- floor(n^0.995)
kmax <- ceiling(n^0.999)
rho_est <- rho.fagh(
   xdat = xdat,
   k = n - kmin:kmax)
rho_med <- mean(rho_est$rho)
}
\references{
Fraga Alves, M.I., Gomes, M. Ivette, and de Haan, Laurens (2003). A new class of semi-parametric estimators of the second order parameter. \emph{Portugaliae Mathematica}. Nova Serie 60(\bold{2}), 193-213. <http://eudml.org/doc/50867>.
}
