% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metafeatures.R
\name{metafeatures}
\alias{metafeatures}
\alias{metafeatures.default}
\alias{metafeatures.formula}
\title{Extract meta-features from a dataset}
\usage{
metafeatures(...)

\method{metafeatures}{default}(x, y, groups = "all", summary = c("mean",
  "sd"), ...)

\method{metafeatures}{formula}(formula, data, groups = "all",
  summary = c("mean", "sd"), ...)
}
\arguments{
\item{...}{Optional arguments to the summary methods.
#' @param formula A formula to define the class column.}

\item{x}{A data.frame contained only the input attributes.}

\item{y}{A factor response vector with one label for each row/component of x.}

\item{groups}{A list of meta-features groups or \code{"all"} to include all
them. The details section describes the valid values for this parameter.}

\item{summary}{A list of methods to summarize the results as post-processing
functions. See \link{post.processing} method to more information. (Default:
\code{c("mean", "sd")})}

\item{formula}{A formula to define the class column.}

\item{data}{A data.frame dataset contained the input attributes and class
The details section describes the valid values for this group.}
}
\value{
A numeric vector named by the requested meta-features.
}
\description{
This is a simple way to extract the meta-features from a dataset. To set
specific parameters for each group, use the specific characterization method.
}
\details{
The following groups are allowed for this method:
 \describe{
   \item{"discriminant"}{Include all discriminant meta-features. See
     \link{mf.discriminant} for more details.}
   \item{"infotheo"}{Include all information theoretical meta-features. See
     \link{mf.infotheo} for more details.}
   \item{"general"}{Include all general meta-features. See
     \link{mf.general} for more details.}
   \item{"landmarking"}{Include all landmarking meta-features. See
     \link{mf.landmarking} for more details.}
   \item{"model.based"}{Include all model based meta-features. See
     \link{mf.model.based} for more details.}
   \item{"statistical"}{Include all statistical meta-features. See
     \link{mf.statistical} for more details.}
 }
}
\examples{
## Extract all meta-features
metafeatures(Species ~ ., iris)

## Extract some groups of meta-features
metafeatures(iris[1:4], iris[5], c("general", "statistical", "infotheo"))

## Use another summary methods
metafeatures(Species ~ ., iris, summary=c("min", "median", "max"))
}

