% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addPubmed_function.R
\name{addPubmed}
\alias{addPubmed}
\title{Adds number of titles from Pubmed to list}
\usage{
addPubmed(mgl, max = 30000)
}
\arguments{
\item{mgl}{List; see \code{\link{buildFromNames}}, \code{\link{buildFromRegion}}, or \code{\link{buildFromEnsgs}}}

\item{max}{Maximum number of papers to return (i.e. this value will be returned if the number of papers exceeds it)}
}
\description{
\code{addGo} returns an 'mgl' list with the sixth element as the number of titles from scientific publications indexed in Pubmed that reference the gene of interest.  Please note that this function is a modification of GetPubMed from the NCBI2R package written by Scott Melville and archived on CRAN (see \url{https://ncbi2r.wordpress.com/})
}
\examples{
\dontrun{buildFromRegion(chr = 2, start = 102314000, stop = 103435000) -> myMgl}
\dontrun{myMgl <- addPubmed(myMgl)}

}
\seealso{
Other elements: \code{\link{addAei}},
  \code{\link{addAntisense}}, \code{\link{addCisEqtl}},
  \code{\link{addDnase}}, \code{\link{addEnst}},
  \code{\link{addExpression}}, \code{\link{addGo}},
  \code{\link{addGrasp}}, \code{\link{addGwasCatalog}},
  \code{\link{addLoc}}, \code{\link{addPtv}},
  \code{\link{addSqtlAltrans}}, \code{\link{addSqtlSeek}},
  \code{\link{addTransEqtl}}, \code{\link{missNames}}
}

