% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeCoXpTranscript_function.R
\name{makeCoXpTranscript}
\alias{makeCoXpTranscript}
\title{Tests pairwise co-expression between user defined transcripts in specified tissues}
\usage{
makeCoXpTranscript(mgl, transcripts = c(), genes = c(), data = c(9, 11),
  makePlot = FALSE, saveFile = FALSE, tissue = c("All",
  "Adipose - Subcutaneous", "Adipose - Visceral (Omentum)", "Adrenal Gland",
  "Artery - Aorta", "Artery - Coronary", "Artery - Tibial", "Bladder",
  "Brain - Amygdala", "Brain - Anterior cingulate cortex (BA24)",
  "Brain - Caudate (basal ganglia)", "Brain - Cerebellar Hemisphere",
  "Brain - Cerebellum", "Brain - Cortex", "Brain - Frontal Cortex (BA9)",
  "Brain - Hippocampus", "Brain - Hypothalamus",
  "Brain - Nucleus accumbens (basal ganglia)",
  "Brain - Putamen (basal ganglia)", "Brain - Spinal cord (cervical c-1)",     
  "Brain - Substantia nigra", "Breast - Mammary Tissue",
  "Cells - EBV-transformed lymphocytes", "Cells - Transformed fibroblasts",
  "Cervix - Ectocervix", "Cervix - Endocervix", "Colon - Sigmoid",
  "Colon - Transverse", "Esophagus - Gastroesophageal Junction",
  "Esophagus - Mucosa", "Esophagus - Muscularis", "Fallopian Tube",
  "Heart - Atrial Appendage", "Heart - Left Ventricle", "Kidney - Cortex",
  "Liver", "Lung", "Minor Salivary Gland", "Muscle - Skeletal",
  "Nerve - Tibial", "Ovary", "Pancreas",      "Pituitary", "Prostate",
  "Skin - Not Sun Exposed (Suprapubic)", "Skin - Sun Exposed (Lower leg)",
  "Small Intestine - Terminal Ileum", "Spleen", "Stomach", "Testis", "Thyroid",
  "Uterus", "Vagina", "Whole Blood"))
}
\arguments{
\item{mgl}{List; see \code{\link{buildFromNames}}, \code{\link{buildFromRegion}}, or \code{\link{buildFromEnsgs}}}

\item{transcripts}{Character vector indicating transcripts to be considered (see mgl[[x]][[2]] where x is number 
corresponding to gene of interest)}

\item{genes}{Character vector indicating genes corresponding to transcripts to be considered (note gene names must match names(mgl))}

\item{data}{Number corresponding to element of mgl containing data of interest: 8 for count data and 10 for RPKM}

\item{makePlot}{A logical flag indicating whether a pdf file ('CoXpGene.pdf') should be saved in the current directory}

\item{saveFile}{A logical flag indicating whether a csv file ('CoXpGene.csv') should be saved in the current directory. 'CoXpGene.csv' contains cor.test results}

\item{tissue}{Character vector indicating tissues to be considered (note tissue names must match those provided here: c('All', 'Adipose - Subcutaneous', 'Adipose - Visceral (Omentum)', 'Adrenal Gland', 'Artery - Aorta', 'Artery - Coronary', 'Artery - Tibial', 'Bladder', 'Brain - Amygdala', 'Brain - Anterior cingulate cortex (BA24)', 'Brain - Caudate (basal ganglia)', 'Brain - Cerebellar Hemisphere', 'Brain - Cerebellum', 'Brain - Cortex', 'Brain - Frontal Cortex (BA9)', 'Brain - Hippocampus', 'Brain - Hypothalamus', 'Brain - Nucleus accumbens (basal ganglia)', 'Brain - Putamen (basal ganglia)', 'Brain - Spinal cord (cervical c-1)', 'Brain - Substantia nigra', 'Breast - Mammary Tissue', 'Cells - EBV-transformed lymphocytes', 'Cells - Transformed fibroblasts', 'Cervix - Ectocervix', 'Cervix - Endocervix', 'Colon - Sigmoid', 'Colon - Transverse', 'Esophagus - Gastroesophageal Junction', 'Esophagus - Mucosa', 'Esophagus - Muscularis', 'Fallopian Tube', 'Heart - Atrial Appendage', 'Heart - Left Ventricle', 'Kidney - Cortex', 'Liver', 'Lung', 'Minor Salivary Gland', 'Muscle - Skeletal', 'Nerve - Tibial', 'Ovary', 'Pancreas', 'Pituitary', 'Prostate', 'Skin - Not Sun Exposed (Suprapubic)', 'Skin - Sun Exposed (Lower leg)', 'Small Intestine - Terminal Ileum', 'Spleen', 'Stomach', 'Testis', 'Thyroid', 'Uterus', 'Vagina', 'Whole Blood'))}
}
\description{
\code{makeCoXpTranscript} returns a list of cor.test output for each transcript pair in a given tissue
}
\details{
Uses the cor.test function in R to test for co-expression between transcripts.  Option to generate scatter plots and a summary table of the correlations to be saved as a pdf and csv, respectively.  Any number of transcripts and tissues can be included. Counts (data = 9) or RPKM (data = 11) can be used.
}
\examples{
exMgl() -> myMgl
makeCoXpTranscript(myMgl, transcripts = 
    c('ENST00000344348', 'ENST00000414907', 'ENST00000478719'), 
    genes = c('NCOA4', 'NCOA4', 'MSMB'), tissue = c('Prostate'), 
    data = 9, makePlot = FALSE, saveFile = FALSE)

}
\seealso{
Other output: \code{\link{makeAeiPlot}},
  \code{\link{makeCoXpGene}}, \code{\link{makeDnaseSig}},
  \code{\link{makeGoSearch}}, \code{\link{makeGo}},
  \code{\link{makeMultiEqtl}},
  \code{\link{makeOverlapTable}},
  \code{\link{makeOverlap}},
  \code{\link{makePhenotypeSearch}},
  \code{\link{makePhenotypes}},
  \code{\link{makeSnpSearch}}, \code{\link{makeSnps}},
  \code{\link{makeSummary}}
}

