% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeMultiEqtl_function.R
\name{makeMultiEqtl}
\alias{makeMultiEqtl}
\title{Returns SNPs identified as cis-eQTLs for more than one gene}
\usage{
makeMultiEqtl(mgl, makePlot = FALSE, saveFile = FALSE, cis = TRUE,
  trans = TRUE, tissue = c("All", "Adipose_Subcutaneous",
  "Adipose_Visceral_Omentum", "Adrenal_Gland", "Artery_Aorta",
  "Artery_Coronary", "Artery_Tibial", "Brain_Anterior_cingulate_cortex_BA24",
  "Brain_Caudate_basal_ganglia", "Brain_Cerebellar_Hemisphere",
  "Brain_Cerebellum", "Brain_Cortex", "Brain_Frontal_Cortex_BA9",
  "Brain_Hippocampus", "Brain_Hypothalamus",
  "Brain_Nucleus_accumbens_basal_ganglia", "Brain_Putamen_basal_ganglia",
  "Breast_Mammary_Tissue", "Cells_EBV-transformed_lymphocytes",
  "Cells_Transformed_fibroblasts",      "Colon_Sigmoid", "Colon_Transverse",
  "Esophagus_Gastroesophageal_Junction", "Esophagus_Mucosa",
  "Esophagus_Muscularis", "Heart_Atrial_Appendage", "Heart_Left_Ventricle",
  "Liver", "Lung", "Muscle_Skeletal", "Nerve_Tibial", "Ovary", "Pancreas",
  "Pituitary", "Prostate", "Skin_Not_Sun_Exposed_Suprapubic",
  "Skin_Sun_Exposed_Lower_leg", "Small_Intestine_Terminal_Ileum", "Spleen",
  "Stomach", "Testis", "Thyroid", "Uterus", "Vagina", "Whole_Blood"))
}
\arguments{
\item{mgl}{List; see \code{\link{buildFromNames}}, \code{\link{buildFromRegion}}, or \code{\link{buildFromEnsgs}}}

\item{makePlot}{A logical flag indicating whether a pdf ('MultiEqtl.pdf') should be saved in the current directory}

\item{saveFile}{A logical flag indicating whether a csv ('MulitEqtl.csv') should be saved in the current directory. 'MultiEqtl.csv' contains those eQTLs, along with their corresponding genes and tissues, that serve as eQTLs for the greatest number of genes}

\item{cis}{A logical flag indicating whether cisEqtls should be included}

\item{trans}{A logical flag indicating whether transEqtls should be included}

\item{tissue}{Character vector indicating tissues to be considered (note tissue names much match those provided here: c('All','Adipose_Subcutaneous', 'Adipose_Visceral_Omentum', 'Adrenal_Gland', 'Artery_Aorta', 'Artery_Coronary', 'Artery_Tibial', 'Brain_Anterior_cingulate_cortex_BA24', 'Brain_Caudate_basal_ganglia', 'Brain_Cerebellar_Hemisphere', 'Brain_Cerebellum', 'Brain_Cortex', 'Brain_Frontal_Cortex_BA9', 'Brain_Hippocampus', 'Brain_Hypothalamus', 'Brain_Nucleus_accumbens_basal_ganglia', 'Brain_Putamen_basal_ganglia', 'Breast_Mammary_Tissue', 'Cells_EBV-transformed_lymphocytes', 'Cells_Transformed_fibroblasts', 'Colon_Sigmoid', 'Colon_Transverse', 'Esophagus_Gastroesophageal_Junction', 'Esophagus_Mucosa', 'Esophagus_Muscularis', 'Heart_Atrial_Appendage', 'Heart_Left_Ventricle', 'Liver', 'Lung', 'Muscle_Skeletal', 'Nerve_Tibial', 'Ovary', 'Pancreas', 'Pituitary', 'Prostate', 'Skin_Not_Sun_Exposed_Suprapubic', 'Skin_Sun_Exposed_Lower_leg', 'Small_Intestine_Terminal_Ileum', 'Spleen', 'Stomach', 'Testis', 'Thyroid', 'Uterus', 'Vagina', 'Whole_Blood'))}
}
\description{
\code{makeMultiEqtl} returns information about SNPs that appear as eQTLs for more than one of the candidate genes.  It can be done across all tissues by selecting tissue = 'All' or for a specific tissue.  Note: multiple tissues can be selected at once.
}
\details{
The output is a four element list - with each of the four elements being a list corresponding to the number of tissues selected in the function.  For the first element (\emph{'fullTable'}) the list is comprised of dataframes with three columns: gene, tissue, and snp.  The second element of the output (\emph{'ranking'}) is a list of tables ranking the number of genes each eQTL is assigned to.  The third element (\emph{'topSnps'}) of the output is a list of vectors of eQTLs appearing for the maximum number of genes (note the exact number will vary based on candidate genes and tissues considered).  The fourth element (\emph{'topSummary'}) is a list of the fullTable objects subsetted to include only the top SNPs - this is saved in the csv file if \emph{saveFile = TRUE}.  The plot that is generated (\emph{'MultiEqtl.pdf'}) is a heatmap of eQTLs for the selected tissue displaying SNPs along the x-axis and genes along the y-axis.  SNPs that are eQTLs for a given gene are colored in blue, while those that are eQTLs for another gene are colored in black.  Genes are clustered by the number of shared eQTLs as shown in the dendogram on the left.
}
\examples{
exMgl() -> myMgl
makeMultiEqtl(myMgl, makePlot = FALSE, saveFile = FALSE, cis = TRUE, trans = TRUE, 
    tissue = c('All', 'Thyroid', 'Spleen')) -> results

}
\seealso{
Other output: \code{\link{makeAeiPlot}},
  \code{\link{makeCoXpGene}},
  \code{\link{makeCoXpTranscript}},
  \code{\link{makeDnaseSig}}, \code{\link{makeGoSearch}},
  \code{\link{makeGo}}, \code{\link{makeOverlapTable}},
  \code{\link{makeOverlap}},
  \code{\link{makePhenotypeSearch}},
  \code{\link{makePhenotypes}},
  \code{\link{makeSnpSearch}}, \code{\link{makeSnps}},
  \code{\link{makeSummary}}
}

