% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makePhenotypes_function.R
\name{makePhenotypes}
\alias{makePhenotypes}
\title{Make list of GWAS-based traits}
\usage{
makePhenotypes(mgl, saveFile = FALSE)
}
\arguments{
\item{mgl}{List; see \code{\link{buildFromNames}}, \code{\link{buildFromRegion}}, or \code{\link{buildFromEnsgs}}}

\item{saveFile}{A logical flag indicating whether a csv file ('Phenotypes.csv') should be saved in the current directory.}
}
\description{
\code{makePhenotypes} returns a list with four elements summarizing the traits or phenotypes associated with each gene via GWAS results reported in both the GWAS catalog and GRASP.  The first element (phenRes) is a list with length corresponding to the number of candidate genes and includes all GWAS-based phenotypes split by source: NHGRI-EBI GWAS Catalog and GRASP.  The second element (phenList) collpases the first so only phenotypes for each gene are listed, regardless of the source.  The third element (phenTable) is a dataframe with two columns: Phenotypes and gene names.  The fourth element (phenCount) is a table with the number of elements corresponding to the number of unique phenotypes in the genelist - reported for each phenotype is the number of times it appears.  It is sorted in descending order.  The structure is similar to the \code{\link{makeGo}} and \code{\link{makeSnps}} functions.
}
\details{
This gives a summary of all traits associated with the gene in the NHGRI-EBI GWAS catalog and GRASP.
}
\examples{
exMgl() -> myMgl
myPhenotypes <- makePhenotypes(myMgl, saveFile = FALSE)

}
\seealso{
Other output: \code{\link{makeAeiPlot}},
  \code{\link{makeCoXpGene}},
  \code{\link{makeCoXpTranscript}},
  \code{\link{makeDnaseSig}}, \code{\link{makeGoSearch}},
  \code{\link{makeGo}}, \code{\link{makeMultiEqtl}},
  \code{\link{makeOverlapTable}},
  \code{\link{makeOverlap}},
  \code{\link{makePhenotypeSearch}},
  \code{\link{makeSnpSearch}}, \code{\link{makeSnps}},
  \code{\link{makeSummary}}
}

