% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genClaytonReg.R
\name{genClaytonReg}
\alias{genClaytonReg}
\title{Generates regression data from a bivariate Clayton-Oakes model}
\usage{
genClaytonReg(
  n,
  theta,
  Xp,
  lambda10,
  lambda01,
  b10,
  b01,
  b11,
  lambdaC1,
  lambdaC2
)
}
\arguments{
\item{n}{Sample size for the simulated data set.}

\item{theta}{Parameter for the Clayton copula. Must be -1 or larger.}

\item{Xp}{Probability that the covariate is equal to 1. Must satisfy
0<Xp<1.}

\item{lambda10, lambda01}{Rate parameters for the (marginal) exponential
distributions when X=0.}

\item{b10, b01, b11}{Regression coefficient values.}

\item{lambdaC1, lambdaC2}{Rate parameters for the censoring times. No
censoring occurs if this paramter is equal to 0.}
}
\value{
A data frame containing the following elements:
\describe{
\item{Y1, Y2:}{Survival times for the simulated data}
\item{Delta1, Delta2:}{Censoring indicators for the simulated data}
}
\item{X}{Covariate matrix (of dimension n x 1).}
}
\description{
Generates simulated survival data from a bivariate Clayton-Oakes model
where the hazard depends on a binary coefficient X. This can be used to
create example data for bivariate Cox regression. The marginal
distributions are exponential with given rate parameters. The joint
distribution is defined using a Clayton copula. The censoring times are
also exponentially distributed with given rate parameters.
}
\section{Details}{

This function simulates data with the following survival function:
F(t1,t2) = [F(t1,0)^(-eta) + F(0,t2)^(-eta) - 1]^(-1/eta)
(The survival function is defined to be equal to 0 if this
quantity is negative.) Here eta=theta\emph{exp(X}b11). The marginal
survival functions F(t1,0) and F(0,t2) are exponentially distributed
with rate parameters lambda10\emph{exp(X}b10) and lambda01\emph{exp(X}b01),
respectively. After generating survival times Y1 and Y2 (of
length n) under this distribution, censoring times C1 and C2 (also of
length n) are generated. C1/C2 are generated under an exponential
distribution with rate parameters lambdaC1 and lambdaC2. If
C1[i]<Y1[i] for a given observation i, then observation i is
considered to be censored (i.e., Delta1[i]=0). Delta2 is defined in
a similar manner. If lambdaC1 or lambdaC2 is equal to 0, then the
corresponding variable is uncensored (meaning that Delta[i]=1 for
all i).
}

\examples{
x <- genClaytonReg(1000, 2, 0.5, 1, 1, log(2), log(2), log(8/3), 2, 2)
}
\references{
Clayton, D. "Model for association in bivariate life tables and its
application in epidemiological studies of familial tendency in chronic
disease incidence.", Biometrika (1978) 65:141-151.
Prentice, R., Zhao, S. "The statistical analysis of multivariate
failure time data: A marginal modeling approach", CRC Press (2019).
}
