% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_single_term.R
\name{indicate_term}
\alias{indicate_term}
\title{Indicate if a term is contained in abstracts}
\usage{
indicate_term(
  df,
  term,
  threshold = 1,
  case = FALSE,
  discard = FALSE,
  col.abstract = Abstract
)
}
\arguments{
\item{df}{Data frame containing abstracts.}

\item{term}{Character vector. Vector containing terms to indicate.}

\item{threshold}{Integer. Sets how often a term must be in an abstract to be
considered "present".}

\item{case}{Boolean. If \code{case = TRUE}, strings contained in \code{term} are case
sensitive. If \code{case = FALSE}, strings contained in \code{term} are case insensitive.}

\item{discard}{Boolean. If \code{discard = TRUE}, only abstracts containing the
terms in \code{term} are kept.}

\item{col.abstract}{Symbol. Column containing abstracts.}
}
\value{
Data frame. If \code{discard = FALSE}, the original data frame with additional
columns per term is returned. If \code{discard = TRUE}, only abstracts containing the
terms in \code{term} are returned.
}
\description{
Indicate if a term is contained in abstracts.
}
\details{
Indicate if a term is contained in an abstract. Terms provided can either
be case sensitive or insensitive. Per term, a new column is added to the data
frame indicating if the term is present in an abstract. Furthermore, if a term
is considered "present" in an abstract can be regulated via the \code{threshold}
argument. \code{threshold} determines how often a term must be in an abstract
to be considered "present".
}
\seealso{
\code{\link[=indicate_mir]{indicate_mir()}}

Other indicate functions: 
\code{\link{indicate_mir}()}
}
\concept{indicate functions}
