% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_mir_terms.R
\name{plot_mir_terms}
\alias{plot_mir_terms}
\title{Plot count of top terms associated with a miRNA name}
\usage{
plot_mir_terms(
  df,
  mir,
  top = 20,
  tf.idf = FALSE,
  token = "words",
  ...,
  stopwords = stopwords_miretrieve,
  stopwords_ngram = TRUE,
  normalize = TRUE,
  colour = "steelblue3",
  col.mir = miRNA,
  col.abstract = Abstract,
  col.pmid = PMID,
  title = NULL
)
}
\arguments{
\item{df}{Data frame containing miRNA names, abstracts, and PubMed-IDs.}

\item{mir}{String. miRNA name of interest.}

\item{top}{Integer. Number of top terms to plot.}

\item{tf.idf}{Boolean. If \code{tf.idf = TRUE}, terms are weighed in a tf-idf
fashion. miRNA names are considered as separate documents and terms often
associated with one miRNA, but not with other miRNAs get more weight.}

\item{token}{String. Specifies how abstracts shall be split up. Taken from
\code{unnest_tokens()} in the \pkg{tidytext} package:
"Unit for tokenizing, or a custom tokenizing function. Built-in options are
"words" (default), "characters", "character_shingles", "ngrams", "skip_ngrams",
"sentences", "lines", "paragraphs", "regex",
(...),
and "ptb" (Penn Treebank). If a function, should take a character vector and
return a list of character vectors of the same length."}

\item{...}{Additional arguments for tokenization, if necessary.}

\item{stopwords}{Data frame containing stop words.}

\item{stopwords_ngram}{Boolean. Specifies if stop words shall be removed
from abstracts when using ngrams. Only applied when \code{token = 'ngrams'}.}

\item{normalize}{Boolean. If \code{normalize = TRUE}, normalizes the number of
abstracts to the total number of abstracts with a miRNA name in a topic. Cannot
be applied with \code{tf.idf = TRUE}.}

\item{colour}{String. Colour of bar plot.}

\item{col.mir}{Symbol. Column containing miRNA names}

\item{col.abstract}{Symbol. Column containing abstracts.}

\item{col.pmid}{Symbol. Column containing PubMed-IDs.}

\item{title}{String. Title plot.}
}
\value{
Bar plot displaying the count of the top terms associated with a
miRNA name.
}
\description{
Plot count of top terms associated with a miRNA name.
}
\details{
Plot count of top terms associated with a miRNA name.
Top terms associated with \code{mir} have to be in \code{df} as abstracts.
Number of top terms to plot is regulated via the \code{top} argument.
Terms can either be evaluated as their count or in a tf-idf fashion.
If terms are evaluated as their count, they can either be
evaluated as their raw count, e.g. in how many abstracts they are mentioned
in conjunction with the miRNA name, or as their relative count, e.g.
in how many abstracts containing the miRNA they are mentioned compared to all
abstracts containing the miRNA.
If terms are evaluated in a tf-idf fashion, miRNA names are considered as
separate documents and
terms often associated with one miRNA, but not with other miRNAs get
more weight.
\code{plot_mir_terms()} is based on the tools available in the \pkg{tidytext} package.
}
\seealso{
\code{\link[=plot_wordcloud]{plot_wordcloud()}}, \code{\link[tidytext:unnest_tokens]{tidytext::unnest_tokens()}}

Other miR term functions: 
\code{\link{plot_wordcloud}()}
}
\concept{miR term functions}
