\name{mice.impute.passive}
\alias{mice.impute.passive}
\title{Passive Imputation}
\usage{
mice.impute.passive(data, func)
}
\description{Derive a new variable based on the imputed data
}

\arguments{
  \item{data}{A data frame}
  \item{func}{A \code{formula} specifying the transformations on data}
}

\value{
  \item{t}{The transformed data}
}

\details{
  Passive imputation is a special internal imputation function. 
  Using this facility, the user can specify, at any point in the \code{mice} 
  Gibbs sampling algorithm, a function on the imputed data. 
  This is useful, for example, to compute a cubic version
  of a variable, a transformation like \code{Q = W/H^2} based on two variables, 
  or a mean variable like \code{(x_1+x_2+x_3)/3}. The so derived variables might be
  used in other places in the imputation model.
  The function allows to dynamically derive virtually any function 
  of the imputed data at virtually any time. 
}
\references{
Van Buuren, S., Groothuis-Oudshoorn, K. (2010) 
MICE: Multivariate Imputation by Chained Equations in R. 
\emph{Journal of Statistical Software}, forthcoming.
\url{http://www.stefvanbuuren.nl/publications/MICE in R - Draft.pdf}
}
\seealso{
  \code{\link{mice}}
}


\author{Stef van Buuren, Karin Groothuis-Oudshoorn, 2000} 
\keyword{datagen} 
