# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' \code{VIF} function for assessing VIF.
#'
#' @description VIF measure how much the variance of the estimated regression coefficients are inflated.
#' It helps to identify when the predictor variables are linearly related.
#' You have to decide which variable should be delete. Values higher than 10 signal a potential collinearity problem.
#'
#' @param x a numeric matrix - a numeric matrix with variables
#' @param posit_y an integer - a position of dependent variable
#' @param posit_x an integer vector - positions of independent variables
#'
#' @return load a numeric vector with VIF for all variables provided by posit_x
#'
#' @seealso \code{\link{fill_NA}} \code{\link{fill_NA_N}}
#'
#' @examples
#' \dontrun{
#' library(miceFast)
#' library(data.table)
#'
#' airquality2 = airquality
#' airquality2$Temp2 = airquality2$Temp**2
#' #install.packages("car")
#' #car::vif(lm(Ozone ~ ., data=airquality2))
#'
#'
#' data_DT = data.table(airquality2)
#' # VIF for variables at 1,3,4 positions - you include a y position to consider its NA values
#' data_DT[,.(vifs=VIF(x=as.matrix(.SD),
#'                     posit_y=1,
#'                     posit_x=c(2,3,4,5,6,7)))]
#'
#' ######################
#' #OR using OOP miceFast
#' ######################
#'
#' airquality2_mat = as.matrix(airquality2)
#' model = new(miceFast)
#' model$set_data(airquality2_mat)
#'
#' as.vector(model$vifs(1,c(2,3,4,5,6,7)))
#'
#' }
#'
#' @export
VIF <- function(x, posit_y, posit_x) {
    .Call(`_miceFast_VIF`, x, posit_y, posit_x)
}

#' \code{fill_NA_N} function for the multiple imputations purpose.
#'
#' @description Multiple imputations to fill the missing data.
#' Non missing independent variables are used to approximate a missing observations for a dependent variable.
#' Quantitative models were built under Rcpp packages and the C++ library Armadillo.
#'
#' @param x a numeric matrix - a numeric matrix with variables
#' @param model a character - posibble options ("lm_bayes","lm_noise")
#' @param posit_y an integer - a position of dependent variable
#' @param posit_x an integer vector - positions of independent variables
#' @param w  a numeric vector - a weighting variable - only positive values
#' @param times an integer - a number of multiple imputations - default 10
#'
#' @return load variable at position y with additional average of N imputations in a numeric vector format
#'
#' @note The lda model is assessed only if there are more than 15 complete observations
#' and for the lms models if number of variables is smaller than number of observations.
#'
#' @seealso \code{\link{fill_NA}} \code{\link{VIF}}
#'
#' @examples
#' \dontrun{
#' library(miceFast)
#' library(data.table)
#' library(magrittr)
#'
#' data = cbind(as.matrix(airquality[,-5]),intercept=1,index=1:nrow(airquality),
#'              # a numeric vector - positive values
#'              weights = round(rgamma(nrow(airquality),3,3),1),
#'              # as.numeric is needed only for OOP miceFast - see on next pages
#'              groups = airquality[,5])
#' data_DT = data.table(data)
#'
#' # simple mean imputation - intercept at position 6
#' data_DT[,Ozone_imp:=fill_NA(x=as.matrix(.SD),
#'                            model="lm_pred",
#'                            posit_y=1,
#'                            posit_x=c(6),w=.SD[['weights']]),by=.(groups)] %>%
#' # avg of 10 multiple imputations - last posit_x equal to 9 not 10
#' # because the groups variable is not included in .SD
#' .[,Solar_R_imp:=fill_NA_N(as.matrix(.SD),
#'                          model="lm_bayes",
#'                          posit_y=2,
#'                          posit_x=c(3,4,5,6,9),w=.SD[['weights']],times=10),by=.(groups)]
#'
#' head(data_DT,10)
#'
#' ######################
#' #OR using OOP miceFast
#' ######################
#'
#' data = cbind(as.matrix(airquality[,-5]),intercept=1,index=1:nrow(airquality))
#' weights = rgamma(nrow(data),3,3) # a numeric vector - positive values
#' #a numeric vector not integers - positive values - sorted increasingly
#' groups = as.numeric(airquality[,5])
#' #a numeric vector not integers - positive values - not sorted
#' #groups = as.numeric(sample(1:8,nrow(data),replace=T))
#'
#' model = new(miceFast)
#' model$set_data(data) # providing data by a reference
#' model$set_w(weights) # providing by a reference
#' model$set_g(groups)  # providing by a reference
#'
#' #impute adapt to provided parmaters like w or g
#' #Simple mean - permanent imputation at the object and data
#' #variable will be replaced by imputations
#' model$update_var(1,model$impute("lm_pred",1,c(6))$imputations)
#'
#' model$update_var(2,model$impute_N("lm_bayes",2,c(1,3,4,5,6),10)$imputations)
#'
#' #Printing data and retrieving an old order if data was sorted by the grouping variable
#' head(cbind(model$get_data(),model$get_g(),model$get_w())[order(model$get_index()),],3)
#' #the same
#' head(cbind(data,groups,weights)[order(model$get_index()),],3)
#'
#'
#' }
#'
#' @export
#'
fill_NA_N <- function(x, model, posit_y, posit_x, w = 0L, times = 10L) {
    .Call(`_miceFast_fill_NA_N`, x, model, posit_y, posit_x, w, times)
}

#' \code{fill_NA} function for the imputations purpose.
#'
#' @description Regular imputations to fill the missing data.
#' Non missing independent variables are used to approximate a missing observations for a dependent variable.
#' Quantitative models were built under Rcpp packages and the C++ library Armadillo.
#'
#' @param x a numeric matrix - a numeric matrix with variables
#' @param model a character - posibble options ("lda","lm_pred","lm_bayes","lm_noise")
#' @param posit_y an integer - a position of dependent variable
#' @param posit_x an integer vector - positions of independent variables
#' @param w  a numeric vector - a weighting variable - only positive values
#'
#' @return load variable at position y with additional imputations in a numeric vector format
#'
#' @note The lda model is assessed only if there are more than 15 complete observations
#' and for the lms models if number of independent variables is smaller than number of observations.
#'
#' @seealso \code{\link{fill_NA_N}}  \code{\link{VIF}}
#'
#' @examples
#' \dontrun{
#' library(miceFast)
#' library(data.table)
#' library(magrittr)
#'
#' data = cbind(as.matrix(airquality[,-5]),intercept=1,index=1:nrow(airquality),
#'              # a numeric vector - positive values
#'              weights = round(rgamma(nrow(airquality),3,3),1),
#'              # as.numeric is needed only for OOP miceFast - see on next pages
#'              groups = airquality[,5])
#' data_DT = data.table(data)
#'
#' # simple mean imputation - intercept at position 6
#' data_DT[,Ozone_imp:=fill_NA(x=as.matrix(.SD),
#'                            model="lm_pred",
#'                            posit_y=1,
#'                            posit_x=c(6),w=.SD[['weights']]),by=.(groups)] %>%
#' # avg of 10 multiple imputations - last posit_x equal to 9 not 10
#' # because the groups variable is not included in .SD
#' .[,Solar_R_imp:=fill_NA_N(as.matrix(.SD),
#'                          model="lm_bayes",
#'                          posit_y=2,
#'                          posit_x=c(3,4,5,6,9),w=.SD[['weights']],times=10),by=.(groups)]
#'
#' head(data_DT,10)
#'
#' ######################
#' #OR using OOP miceFast
#' ######################
#'
#' data = cbind(as.matrix(airquality[,-5]),intercept=1,index=1:nrow(airquality))
#' weights = rgamma(nrow(data),3,3) # a numeric vector - positive values
#' #a numeric vector not integers - positive values - sorted increasingly
#' groups = as.numeric(airquality[,5])
#' #a numeric vector not integers - positive values - not sorted
#' #groups = as.numeric(sample(1:8,nrow(data),replace=T))
#'
#' model = new(miceFast)
#' model$set_data(data) # providing data by a reference
#' model$set_w(weights) # providing by a reference
#' model$set_g(groups)  # providing by a reference
#'
#' #impute adapt to provided parmaters like w or g
#' #Simple mean - permanent imputation at the object and data
#' #variable will be replaced by imputations
#' model$update_var(1,model$impute("lm_pred",1,c(6))$imputations)
#'
#' model$update_var(2,model$impute_N("lm_bayes",2,c(1,3,4,5,6),10)$imputations)
#'
#' #Printing data and retrieving an old order if data was sorted by the grouping variable
#' head(cbind(model$get_data(),model$get_g(),model$get_w())[order(model$get_index()),],3)
#' #the same
#' head(cbind(data,groups,weights)[order(model$get_index()),],3)
#'
#' }
#'
#' @export
fill_NA <- function(x, model, posit_y, posit_x, w = 0L) {
    .Call(`_miceFast_fill_NA`, x, model, posit_y, posit_x, w)
}

