% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{compare_imp}
\alias{compare_imp}
\title{Comparing imputations and original data distributions}
\usage{
compare_imp(df, origin, target)
}
\arguments{
\item{df}{data.frame with origin variable and the new one with imputations}

\item{origin}{character value - the name of origin variable with values before any imputations}

\item{target}{character vector - names of variables with applied imputations}
}
\value{
ggplot2 object
}
\description{
ggplot2 visualization to support which imputation method to choose
}
\examples{
data(air_miss)
air_miss$Ozone_imp <- fill_NA(
    x = air_miss,
    model = "lm_bayes",
    posit_y = 1,
    posit_x = c(4, 6),
    logreg = TRUE
)
air_miss$Ozone_imp2 <- fill_NA_N(
    x = air_miss,
    model = "pmm",
    posit_y = 1,
    posit_x = c(4, 6),
    logreg = TRUE
)

compare_imp(air_miss, origin = "Ozone", "Ozone_imp")
compare_imp(air_miss, origin = "Ozone", c("Ozone_imp", 'Ozone_imp2'))

}
