% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_prop_wilson.R
\name{pool_prop_wilson}
\alias{pool_prop_wilson}
\title{Calculates the pooled single proportion confidence intervals according
to Wilson across multiply imputed datasets.}
\usage{
pool_prop_wilson(object, conf.level = 0.95)
}
\arguments{
\item{object}{An object of class 'mistats' ('Multiply Imputed
Statistical Analysis').}

\item{conf.level}{Confidence level of the confidence intervals.}
}
\value{
The proportion and the 95\% Confidence interval according to Wilson.
}
\description{
\code{pool_prop_wilson} Calculates the pooled single proportion and
confidence intervals according to Wald across multiply imputed datasets.
}
\examples{

library(magrittr)
lbpmilr \%>\%
  df2milist(impvar="Impnr") \%>\%
    with(expr=prop_wald(Radiation ~ 1)) \%>\%
      pool_prop_wilson()

# Same as
imp_dat <- df2milist(lbpmilr, impvar="Impnr")
ra <- with(imp_dat, expr=prop_wald(Radiation ~ 1))
res <- pool_prop_wilson(ra)

}
\references{
Anne Lott & Jerome P. Reiter (2020) Wilson Confidence Intervals
for Binomial Proportions With Multiple Imputation for Missing Data,
The American Statistician, 74:2, 109-115, DOI: 10.1080/00031305.2018.1473796.
}
\seealso{
\code{\link{with.milist}}, \code{\link{prop_wald}}
}
\author{
Martijn Heymans, 2021
}
