% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_ratio.R
\name{risk_ratio}
\alias{risk_ratio}
\title{Calculates the risk ratio (RR) and standard error.}
\usage{
risk_ratio(y, x, formula, data)
}
\arguments{
\item{y}{0-1 binary response variable.}

\item{x}{0-1 binary independent variable.}

\item{formula}{A formula object to specify the model as
normally used by glm.}

\item{data}{An objects of class \code{milist}, created by
\code{df2milist}, \code{list2milist} or \code{mids2milist}.}
}
\value{
The risk ratio, related standard error and
complete data degrees of freedom (dfcom) as n-2.
}
\description{
\code{risk_ratio} Calculates the risk ratio and standard error.
}
\details{
Note that the standard error of the RR is in fact the
standard error of the (natural) risk ratio.
}
\examples{

imp_dat <- df2milist(lbpmilr, impvar="Impnr")
ra <- with(imp_dat, expr=risk_ratio(Chronic ~ Radiation))

}
\seealso{
\code{\link{with.milist}}
}
\author{
Martijn Heymans, 2021
}
