% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{difftest}
\alias{difftest}
\title{Calculate differential bacteria with DESeq2}
\usage{
difftest(
  physeq,
  group,
  ref = NULL,
  pvalue = 0.05,
  padj = NULL,
  log2FC = 0,
  gm_mean = TRUE,
  fitType = "local",
  quiet = FALSE
)
}
\arguments{
\item{physeq}{A \code{phyloseq} object containing merged information of abundance,
taxonomic assignment, sample data including the measured variables and categorical information
of the samples, and / or phylogenetic tree if available.}

\item{group}{group (DESeq2). A character string specifying the name of a categorical variable containing  grouping information.}

\item{ref}{reference group}

\item{pvalue}{pvalue threshold for significant results}

\item{padj}{adjust p value threshold for significant results}

\item{log2FC}{log2 Fold Change threshold}

\item{gm_mean}{TRUE/FALSE calculate geometric means prior to estimate size factors}

\item{fitType}{either "parametric", "local", or "mean" for the type of fitting of dispersions to the mean intensity.}

\item{quiet}{whether to print messages at each step}
}
\value{
datafame with differential test with DESeq2
}
\description{
Calculate differential bacteria with DESeq2
}
\examples{
 \donttest{
data("Physeq")
res <- difftest(physeq,group="group")
}
}
\author{
Kai Guo
}
